<?php
class SelectCoreElementorVerticalSplitSlider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_vertical_split_slider'; 
	}

	public function get_title() {
		return esc_html__( 'Vertical Split Slider', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-vertical-split-slider';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'left_sliding_panel',
			[
				'label' => esc_html__( 'Left Sliding Panel', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater1 = new \Elementor\Repeater();

		$repeater1->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'select-core' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
			]
		);

		$repeater1->add_control(
			'background_image',
			[
				'label' => esc_html__( 'Background Image', 'select-core' ),
				'type'  => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater1->add_control(
			'item_padding',
			[
				'label'       => esc_html__( 'Padding', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Insert padding in format: Top Right Bottom Left (e.g. 0px 0px 1px 0px)', 'select-core' )
			]
		);

		$repeater1->add_control(
			'alignment',
			[
				'label'       => esc_html__( 'Content Alignment', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''       => esc_html__( 'Default', 'select-core' ),
					'left'   => esc_html__( 'Left', 'select-core' ),
					'right'  => esc_html__( 'Right', 'select-core' ),
					'center' => esc_html__( 'Center', 'select-core' ),
				],
			]
		);

		select_core_generate_elementor_templates_control( $repeater1 );

		$this->add_control(
			'left_slide_content_item',
			[
				'label'       => esc_html__( 'Left Slide Content Items', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater1->get_controls(),
				'title_field' => esc_html__( 'Left Slide Content Item' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'right_sliding_panel',
			[
				'label' => esc_html__( 'Right Sliding Panel', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater2 = new \Elementor\Repeater();

		$repeater2->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'select-core' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
			]
		);

		$repeater2->add_control(
			'background_image',
			[
				'label' => esc_html__( 'Background Image', 'select-core' ),
				'type'  => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater2->add_control(
			'item_padding',
			[
				'label'       => esc_html__( 'Padding', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Insert padding in format: Top Right Bottom Left (e.g. 0px 0px 1px 0px)', 'select-core' )
			]
		);

		$repeater2->add_control(
			'alignment',
			[
				'label'       => esc_html__( 'Content Alignment', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''       => esc_html__( 'Default', 'select-core' ),
					'left'   => esc_html__( 'Left', 'select-core' ),
					'right'  => esc_html__( 'Right', 'select-core' ),
					'center' => esc_html__( 'Center', 'select-core' ),
				],
			]
		);

		select_core_generate_elementor_templates_control( $repeater2 );

		$this->add_control(
			'right_slide_content_item',
			[
				'label'       => esc_html__( 'Right Slide Content Items', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater2->get_controls(),
				'title_field' => esc_html__( 'Right Slide Content Item' ),
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		?>
		<div class="qodef-vertical-split-slider">
			<div class="qodef-vss-ms-left">
				<?php foreach ( $params['left_slide_content_item'] as $left ) {
					$left['background_image']   = !empty($left['background_image']['id']) ? $left['background_image']['id'] : '';
					$left['content_style']      = $this->getContentStyle( $left );
					$left['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($left['template_id']);

					echo qodef_core_get_shortcode_template_part( 'templates/vertical-split-slider-content-item-template', 'vertical-split-slider', '', $left );
				} ?>
			</div>

			<div class="qodef-vss-ms-right">
				<?php foreach ( $params['right_slide_content_item'] as $right ) {
					$right['background_image'] = !empty($right['background_image']['id']) ? $right['background_image']['id'] : '';
					$right['content_style'] = $this->getContentStyle( $right );
					$right['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($right['template_id']);

					echo qodef_core_get_shortcode_template_part('templates/vertical-split-slider-content-item-template', 'vertical-split-slider', '', $right);
				} ?>
			</div>
		</div>
		<?php

	}

	private function getContentStyle($params) {

		$content_style = array();

		if ($params['background_color'] !== '') {
			$content_style[] = 'background-color:'. $params['background_color'];
		}

		if ($params['background_image'] !== '') {
			$url = wp_get_attachment_url($params['background_image']);
			$content_style[] = 'background-image:url('. $url . ')';
		}

		if ($params['item_padding'] !== '') {
			$content_style[] = 'padding:'. $params['item_padding'] . 'px';
		}

		if ($params['alignment'] !== '') {
			$content_style[] = 'text-align:'. $params['alignment'];
		}


		return $content_style;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorVerticalSplitSlider() );