<?php
class SelectCoreElementorUnorderedList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_unordered_list'; 
	}

	public function get_title() {
		return esc_html__( 'List - Unordered', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-unordered-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label'     => esc_html__( 'Style', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'circle' => esc_html__( 'Circle', 'select-core'),
					'line' => esc_html__( 'Line', 'select-core'),
					'arrow' => esc_html__( 'Arrow', 'select-core')
				),
				'default' => 'circle'
			]
		);

		$this->add_control(
			'animate',
			[
				'label'     => esc_html__( 'Animate List', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'font_weight',
			[
				'label'     => esc_html__( 'Font Weight', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core'),
					'normal' => esc_html__( 'Normal', 'select-core'),
					'bold' => esc_html__( 'Bold', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'padding_left',
			[
				'label'     => esc_html__( 'Padding left (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'content',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		extract($params);
		
		$list_item_classes = "";

        if ($style != '') {
			$list_item_classes .= ' qodef-'.$style;
        }

		if ($animate == 'yes') {
			$list_item_classes .= ' qodef-animate-list';
		}
		
		$list_style = '';
		if($padding_left != '') {
			$list_style .= 'padding-left: ' . $padding_left .'px;';
		}
		$content = preg_replace('#^<\/p>|<p>$#', '', $content);
		echo '<div class="qodef-unordered-list '.$list_item_classes.'" '.  mixtape_qodef_get_inline_style($list_style).'>'.do_shortcode($content).'</div>';

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorUnorderedList() );