<?php
class SelectCoreElementorTeam extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_team'; 
	}

	public function get_title() {
		return esc_html__( 'Team', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-team';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'team_type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'main-info-below-image' => esc_html__( 'Main Info Below Image', 'select-core'), 
					'main-info-on-hover' => esc_html__( 'Main Info on Hover', 'select-core')
				),
				'default' => 'main-info-on-hover'
			]
		);

		$this->add_control(
			'team_image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'team_name',
			[
				'label'     => esc_html__( 'Name', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'team_name_tag',
			[
				'label'     => esc_html__( 'Name Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'h2' => esc_html__( 'h2', 'select-core'), 
					'h3' => esc_html__( 'h3', 'select-core'), 
					'h4' => esc_html__( 'h4', 'select-core'), 
					'h5' => esc_html__( 'h5', 'select-core'), 
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h5',
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$this->add_control(
			'team_position',
			[
				'label'     => esc_html__( 'Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'team_description',
			[
				'label'     => esc_html__( 'Description', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$repeater = new \Elementor\Repeater();

		mixtape_qodef_icon_collections()->getElementorParamsArray( $repeater, '', '' );

		$repeater->add_control(
			'team_social_icon_link',
			[
				'label' => esc_html__( 'Social Icon Link', 'select-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'team_social_icon_target',
			[
				'label'   => esc_html__( 'Social Icon Target', 'select-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => '',
					'_self'  => esc_html__('Self', 'select-core'),
					'_blank' => esc_html__('Blank', 'select-core')
				),
			]
		);

		$this->add_control(
			'social_icon',
			[
				'label'       => esc_html__( 'Social Icons', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => esc_html__( 'Social Icon', 'select-core' ),
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['team_image']           = !empty($params['team_image']['id']) ? $params['team_image']['id'] : '';
		$params['team_name_tag']        = $this->getTeamNameTag($params);
		$params['team_social_icons']    = $this->getTeamSocialIcons($params);

		//Get HTML from template based on type of team
		echo qodef_core_get_shortcode_template_part('templates/' . $params['team_type'], 'team', '', $params);

	}

	private function getTeamNameTag($params) {

		$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
		return (in_array($params['team_name_tag'], $headings_array)) ? $params['team_name_tag'] : 'h5';

	}

	private function getTeamSocialIcons($params) {

		$team_social_icons = array();

		if ( !empty($params['social_icon']) ) {

			foreach ( $params['social_icon'] as $icon ) {

				$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey( $icon['icon_pack'] );

				$team_icon_params                  = array();
				$team_icon_params['icon_pack']     = $icon['icon_pack'];
				$team_icon_params[ $iconPackName ] = $icon[ $iconPackName ];
				$team_icon_params['link']          = $icon['team_social_icon_link'];
				$team_icon_params['target']        = $icon['team_social_icon_target'];

				$team_social_icons[] = mixtape_qodef_execute_shortcode( 'qodef_icon', $team_icon_params );

			}
		}

		return $team_social_icons;

	}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorTeam() );