<?php
class SelectCoreElementorSectionTitle extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_section_title'; 
	}

	public function get_title() {
		return esc_html__( 'Section Title', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-section-title';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'before_text',
			[
				'label'     => esc_html__( 'Before Title Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'before_tag',
			[
				'label'     => esc_html__( 'Before Title Text Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'h1' => esc_html__( 'h1', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core'),
					'p' => esc_html__( 'p', 'select-core')
				),
				'default' => 'p',
				'condition' => [
					'before_text!' => ''
				]
			]
		);

		$this->add_control(
			'before_color',
			[
				'label'     => esc_html__( 'Before Text Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'before_text!' => ''
				]
			]
		);

		$this->add_control(
			'before_margin',
			[
				'label'     => esc_html__( 'Before Text Bottom Margin (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'before_text!' => ''
				]
			]
		);

		$this->add_control(
			'title_text',
			[
				'label'     => esc_html__( 'Title Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'h1' => esc_html__( 'h1', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h2',
				'condition' => [
					'title_text!' => ''
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'text_align',
			[
				'label'     => esc_html__( 'Text Align', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'left' => esc_html__( 'Left', 'select-core'),
					'center' => esc_html__( 'Center', 'select-core'),
					'right' => esc_html__( 'Right', 'select-core'),
					'justify' => esc_html__( 'Justify', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'separator',
			[
				'label'     => esc_html__( 'Enable Bottom Separator', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'separator_margin',
			[
				'label'     => esc_html__( 'Separator Top Margin (px, em or %)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['before_tag']   = ! empty( $params['before_tag'] ) ? $params['before_tag'] : 'p';
		$params['title_tag']    = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h2';
		$params['before_style'] = $this->getBeforeTextStyles($params);
		$params['title_style']  = $this->getTitleStyles($params);

		//Get HTML from template
		echo qodef_core_get_shortcode_template_part('templates/section-title-template', 'section-title', '', $params);

	}

	private function getBeforeTextStyles($params) {
		$beforeStyles = array();

		if( ! empty($params['before_color']) ) {
			$beforeStyles[] = 'color:' . $params['before_color'];
		}

		if($params['before_margin'] !== '') {
			$beforeStyles[] = 'margin-bottom:' . mixtape_qodef_filter_px($params['before_margin']) . 'px';
		}

		return implode(';', $beforeStyles);
	}

	private function getTitleStyles($params) {
		$titleStyles = array();

		if( ! empty($params['text_align']) ) {
			$titleStyles[] = 'text-align:' . $params['text_align'];
		}

		if( ! empty($params['title_color']) ) {
			$titleStyles[] = 'color:' . $params['title_color'];
		}

		return implode(';', $titleStyles);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorSectionTitle() );