<?php
class SelectCoreElementorProgressBar extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_progress_bar'; 
	}

	public function get_title() {
		return esc_html__( 'Progress Bar', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-progress-bar';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h6'
			]
		);

		$this->add_control(
			'percent',
			[
				'label'     => esc_html__( 'Percentage', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'percentage_type',
			[
				'label'     => esc_html__( 'Percentage Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'floating' => esc_html__( 'Floating', 'select-core'),
					'static' => esc_html__( 'Static', 'select-core')
				),
				'default' => 'floating',
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'active_bar_color',
			[
				'label'     => esc_html__( 'Active Bar Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['title_tag']           = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h6';
		$params['percentage_classes']  = $this->getPercentageClasses($params);
		$params['progress_bar_styles'] = $this->getProgressBarStyles($params);

		//init variables
		echo qodef_core_get_shortcode_template_part('templates/progress-bar-template', 'progress-bar', '', $params);
		
	}

	private function getPercentageClasses($params){
		
		$percentClassesArray = array();
		
		if(!empty($params['percentage_type']) !=''){
			
			if($params['percentage_type'] == 'floating'){
				
				$percentClassesArray[]= 'qodef-floating';


			}
			elseif($params['percentage_type'] == 'static'){
				
				$percentClassesArray[] = 'qodef-static';
				
			}
		}
		return implode(' ', $percentClassesArray);
	}

    private function getProgressBarStyles($params) {
        $styles = array();

        if(!empty($params['active_bar_color'])) {
            $styles[] = 'background-color: '.$params['active_bar_color'];
        }

        return $styles;
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorProgressBar() );