<?php
class SelectCoreElementorParallaxHolder extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_parallax_holder'; 
	}

	public function get_title() {
		return esc_html__( 'Parallax Holder', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-parallax-holder';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'y_axis_translation',
			[
				'label'     => esc_html__( 'Y Axis Translation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the value in pixels. Negative value changes parallax direction.', 'select-core' ),
				'default'   => '-200'
			]
		);

		select_core_generate_elementor_templates_control( $this );

		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$y_absolute = mixtape_qodef_filter_px($params['y_axis_translation']);
		$smoothness = 20; //1 is for linear, non-animated parallax

		$parallax = '{&quot;y&quot;: '.$y_absolute.', &quot;smoothness&quot;: '.$smoothness.'}';
?>
		<div class="qodef-parallax-holder" data-parallax="<?php echo $parallax ?>">
			<?php echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($params['template_id']); ?>
		</div>

	<?php

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorParallaxHolder() );