<?php
class SelectCoreElementorListOrdered extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_list_ordered'; 
	}

	public function get_title() {
		return esc_html__( 'List - Ordered', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-list-ordered';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'content',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$content = preg_replace('#^<\/p>|<p>$#', '', $params['content']);
		echo '<div class= "qodef-ordered-list" >' . do_shortcode($content) . '</div>';
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorListOrdered() );