<?php
class SelectCoreElementorItemShowcase extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_item_showcase'; 
	}

	public function get_title() {
		return esc_html__( 'Item Showcase', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-item-showcase';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'item_image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'image_top_offset',
			[
				'label'     => esc_html__( 'Image Top Offset', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater = new \Elementor\Repeater();

		mixtape_qodef_icon_collections()->getElementorParamsArray( $repeater, '', '' );

		$repeater->add_control(
			'item_position',
			[
				'label'     => esc_html__( 'Item Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'left' => esc_html__( 'Left', 'select-core'),
					'right' => esc_html__( 'Right', 'select-core')
				),
				'default' => 'left'
			]
		);

		$repeater->add_control(
			'item_title',
			[
				'label'     => esc_html__( 'Item Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'item_text',
			[
				'label'     => esc_html__( 'Item Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'item_link',
			[
				'label'     => esc_html__( 'Item Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'item_title!' => ''
				]
			]
		);

		$repeater->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'item_showcase_list_item',
			[
				'label'     => esc_html__( 'Item Showcase List Item', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['item_image']     = !empty($params['item_image']) ? $params['item_image']['id'] : $params['item_image'];


		$item_showcase_classes = array();
        $item_showcase_classes[] = 'clearfix qodef-item-showcase';
        $item_showcase_class = implode(' ', $item_showcase_classes);

        $item_image_style = '';
        $item_image_style .= 'margin-top:' . mixtape_qodef_filter_px($image_top_offset) . 'px;';
		?>

		<div <?php mixtape_qodef_class_attribute($item_showcase_class); ?>>
			<div class="qodef-item-image" <?php mixtape_qodef_inline_style($item_image_style) ?>>
				<?php
					if ($params['item_image'] != '') {
						echo wp_get_attachment_image($params['item_image'],'full');
					}
				?>
			</div>
			<?php foreach ( $params['item_showcase_list_item'] as $item ) {

				$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($item['icon_pack']);

				$item['icon'] = $item[$iconPackName];
				$item['icon_attributes']['style'] =  $this->getItemIconStyle($item);

				$item['item_showcase_list_item_class'] = $this->getItemShowcaseListItemClass($item);

				echo qodef_core_get_shortcode_template_part( 'templates/item-showcase-list-item-template', 'item-showcase', '', $item );
			} ?>
		</div>
		<?php

	}

	/**
	 * Generates icon styles
	 *
	 * @param $params
	 *
	 * @return array
	 */
	private function getItemIconStyle($params){

		$iconStylesArray = array();
		if(!empty($params['icon_color'])) {
			$iconStylesArray[] = 'color:' . $params['icon_color'];
		}

		return implode(';', $iconStylesArray);
	}


	/**
	 * Return Item Showcase List Item Classes
	 *
	 * @param $params
	 * @return array
	 */
	private function getItemShowcaseListItemClass($params) {

		$item_showcase_list_item_class = array();

		if ($params['item_position'] !== '') {
			$item_showcase_list_item_class[] = 'qodef-item-'. $params['item_position'];
		}

		return implode(' ', $item_showcase_list_item_class);

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorItemShowcase() );