<?php
class SelectCoreElementorImageWithTextOver extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_image_with_text_over'; 
	}

	public function get_title() {
		return esc_html__( 'Image With Text Over', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-image-with-text-over';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select images from media library', 'select-core' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'     => esc_html__( 'Subtitle', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'     => esc_html__( 'Show Button', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'     => esc_html__( 'Button Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label'     => esc_html__( 'Button Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_target',
			[
				'label'     => esc_html__( 'Button Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['image']     = !empty($params['image']) ? $params['image']['id'] : $params['image'];

		echo qodef_core_get_shortcode_template_part('templates/image-with-text-over', 'image-with-text-over', '', $params);

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorImageWithTextOver() );