<?php
class SelectCoreElementorFrameCarousel extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_frame_carousel'; 
	}

	public function get_title() {
		return esc_html__( 'Frame Carousel', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-frame-carousel';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'carousel_image',
			[
				'label'     => esc_html__( 'Carousel Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Recommended image size is 485x275px', 'select-core' )
			]
		);

		$repeater->add_control(
			'active_image',
			[
				'label'     => esc_html__( 'Frame Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Recommended image size is 635x397px', 'select-core' )
			]
		);

		$this->add_control(
			'images',
			[
				'label'     => esc_html__( 'Images', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Auto rotate slides each X seconds', 'select-core' ),
				'options' => array(
					'dark' => esc_html__( 'Dark', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => 'dark'
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'     => esc_html__( 'Slide duration', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Auto rotate slides each X seconds', 'select-core' ),
				'options' => array(
					'3' => esc_html__( '3', 'select-core'),
					'5' => esc_html__( '5', 'select-core'),
					'10' => esc_html__( '10', 'select-core'),
					'disable' => esc_html__( 'Disable', 'select-core')
				),
				'default' => '5000'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['carousel_data'] = $this->getCarouselData($params);
		$params['images'] = $this->getFrameCarouselImages($params);

		echo qodef_core_get_shortcode_template_part('templates/frame-carousel', 'frame-carousel', '', $params);

	}

	private function getFrameCarouselImages($params) {
		
		$new_images = array();

		$images = $params['images'];
		$i = 0;

		if(is_array($images) && count($images) > 0) {
			foreach ($images as $image) {
				$new_images[$i]['carousel_image']['id'] = $image['carousel_image']['id'];
				$new_images[$i]['active_image']['id'] = $image['active_image']['id'];

				$new_images[$i]['carousel_image']['url'] = $image['carousel_image']['url'];
				$new_images[$i]['active_image']['url']   = $image['active_image']['url'];

				$new_images[$i]['carousel_image']['title'] = get_the_title($image['carousel_image']['id']);
				$new_images[$i]['active_image']['title'] = get_the_title($image['active_image']['id']);

				$i++;
			}
		}

		return $new_images;

	}

	private function getCarouselData($params) {

		$carousel_data = array();

		$carousel_data['data-autoplay'] = ($params['autoplay'] !== '') ? $params['autoplay'] : '';

		return $carousel_data;

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorFrameCarousel() );