<?php
class SelectCoreElementorDeviceShowcase extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_device_showcase'; 
	}

	public function get_title() {
		return esc_html__( 'Device Showcase', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-device-showcase';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'typography',
			[
				'label' => esc_html__( 'Typography', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_font_size',
			[
				'label'     => esc_html__( 'Title Font Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'description',
			[
				'label'     => esc_html__( 'Description', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'description!' => ''
				]
			]
		);

		$this->add_control(
			'description_font_size',
			[
				'label'     => esc_html__( 'Description Font Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'description!' => ''
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'images',
			[
				'label' => esc_html__( 'Images', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'desktop_image',
			[
				'label'     => esc_html__( 'Desktop Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'This image will be set inside the desktop browser window.', 'select-core' )
			]
		);

		$this->add_control(
			'desktop_image_link',
			[
				'label'     => esc_html__( 'Desktop Image Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter an external URL to link to.', 'select-core' ),
				'condition' => [
					'desktop_image!' => ''
				]
			]
		);

		$this->add_control(
			'desktop_image_link_target',
			[
				'label'     => esc_html__( 'Desktop Image Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'desktop_image_link!' => ''
				]
			]
		);

		$this->add_control(
			'tablet_image',
			[
				'label'     => esc_html__( 'Tablet Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'This image will be set inside the tablet device frame.', 'select-core' )
			]
		);

		$this->add_control(
			'tablet_image_link',
			[
				'label'     => esc_html__( 'Tablet Image Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter an external URL to link to.', 'select-core' ),
				'condition' => [
					'tablet_image!' => ''
				]
			]
		);

		$this->add_control(
			'tablet_image_link_target',
			[
				'label'     => esc_html__( 'Tablet Image Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'tablet_image_link!' => ''
				]
			]
		);

		$this->add_control(
			'phone_image',
			[
				'label'     => esc_html__( 'Phone Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'This image will be set inside the phone device frame.', 'select-core' )
			]
		);

		$this->add_control(
			'phone_image_link',
			[
				'label'     => esc_html__( 'Phone Image Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter an external URL to link to.', 'select-core' ),
				'condition' => [
					'phone_image!' => ''
				]
			]
		);

		$this->add_control(
			'phone_image_link_target',
			[
				'label'     => esc_html__( 'Phone Image Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'phone_image_link!' => ''
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'behavior',
			[
				'label' => esc_html__( 'Behavior', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'animate',
			[
				'label'     => esc_html__( 'Add interactivity', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['desktop_image']          = !empty($params['desktop_image']) ? $params['desktop_image']['id'] : $params['desktop_image'];
		$params['tablet_image']           = !empty($params['tablet_image']) ? $params['tablet_image']['id'] : $params['tablet_image'];
		$params['phone_image']            = !empty($params['phone_image']) ? $params['phone_image']['id'] : $params['phone_image'];

		$params['holder_classes']       = $this->getHolderClasses($params);
        $params['title_style']          = $this->getTitleStyle($params);
        $params['description_style']    = $this->getDescriptionStyle($params);

		echo qodef_core_get_shortcode_template_part('templates/device-showcase-template', 'device-showcase', '', $params);

	}

    private function getHolderClasses($params) {

        $holder_classes = array();

        if ($params['animate'] !== '') {
            $holder_classes[] = 'qodef-animate-'. $params['animate'];
        }

        return implode(' ', $holder_classes);

    }

    private function getTitleStyle($params) {
        $style = array();

        if ($params['title_color'] !== ''){
            $style[] = 'color:'.$params['title_color'];
        }

        if ($params['title_font_size'] !== ''){
            $style[] = 'font-size:'. mixtape_qodef_filter_px($params['title_font_size']).'px';
        }

        return implode(';', $style);
    }

    private function getDescriptionStyle($params) {
        $style = array();

        if ($params['description_color'] !== ''){
            $style[] = 'color:'.$params['description_color'];
        }

        if ($params['description_font_size'] !== ''){
            $style[] = 'font-size:'. mixtape_qodef_filter_px($params['description_font_size']).'px';
        }

        return implode(';', $style);
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorDeviceShowcase() );