<?php
class SelectCoreElementorCountdown extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_countdown'; 
	}

	public function get_title() {
		return esc_html__( 'Countdown', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-countdown';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'year',
			[
				'label'     => esc_html__( 'Year', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'2017' => esc_html__( '2017', 'select-core'), 
					'2018' => esc_html__( '2018', 'select-core'), 
					'2019' => esc_html__( '2019', 'select-core'), 
					'2020' => esc_html__( '2020', 'select-core'), 
					'2021' => esc_html__( '2021', 'select-core'), 
					'2022' => esc_html__( '2022', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'month',
			[
				'label'     => esc_html__( 'Month', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'1' => esc_html__( 'January', 'select-core'), 
					'2' => esc_html__( 'February', 'select-core'), 
					'3' => esc_html__( 'March', 'select-core'), 
					'4' => esc_html__( 'April', 'select-core'), 
					'5' => esc_html__( 'May', 'select-core'), 
					'6' => esc_html__( 'June', 'select-core'), 
					'7' => esc_html__( 'July', 'select-core'), 
					'8' => esc_html__( 'August', 'select-core'), 
					'9' => esc_html__( 'September', 'select-core'), 
					'10' => esc_html__( 'October', 'select-core'), 
					'11' => esc_html__( 'November', 'select-core'), 
					'12' => esc_html__( 'December', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'day',
			[
				'label'     => esc_html__( 'Day', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'1' => esc_html__( '1', 'select-core'), 
					'2' => esc_html__( '2', 'select-core'), 
					'3' => esc_html__( '3', 'select-core'), 
					'4' => esc_html__( '4', 'select-core'), 
					'5' => esc_html__( '5', 'select-core'), 
					'6' => esc_html__( '6', 'select-core'), 
					'7' => esc_html__( '7', 'select-core'), 
					'8' => esc_html__( '8', 'select-core'), 
					'9' => esc_html__( '9', 'select-core'), 
					'10' => esc_html__( '10', 'select-core'), 
					'11' => esc_html__( '11', 'select-core'), 
					'12' => esc_html__( '12', 'select-core'), 
					'13' => esc_html__( '13', 'select-core'), 
					'14' => esc_html__( '14', 'select-core'), 
					'15' => esc_html__( '15', 'select-core'), 
					'16' => esc_html__( '16', 'select-core'), 
					'17' => esc_html__( '17', 'select-core'), 
					'18' => esc_html__( '18', 'select-core'), 
					'19' => esc_html__( '19', 'select-core'), 
					'20' => esc_html__( '20', 'select-core'), 
					'21' => esc_html__( '21', 'select-core'), 
					'22' => esc_html__( '22', 'select-core'), 
					'23' => esc_html__( '23', 'select-core'), 
					'24' => esc_html__( '24', 'select-core'), 
					'25' => esc_html__( '25', 'select-core'), 
					'26' => esc_html__( '26', 'select-core'), 
					'27' => esc_html__( '27', 'select-core'), 
					'28' => esc_html__( '28', 'select-core'), 
					'29' => esc_html__( '29', 'select-core'), 
					'30' => esc_html__( '30', 'select-core'), 
					'31' => esc_html__( '31', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'hour',
			[
				'label'     => esc_html__( 'Hour', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'0' => esc_html__( '0', 'select-core'), 
					'1' => esc_html__( '1', 'select-core'), 
					'2' => esc_html__( '2', 'select-core'), 
					'3' => esc_html__( '3', 'select-core'), 
					'4' => esc_html__( '4', 'select-core'), 
					'5' => esc_html__( '5', 'select-core'), 
					'6' => esc_html__( '6', 'select-core'), 
					'7' => esc_html__( '7', 'select-core'), 
					'8' => esc_html__( '8', 'select-core'), 
					'9' => esc_html__( '9', 'select-core'), 
					'10' => esc_html__( '10', 'select-core'), 
					'11' => esc_html__( '11', 'select-core'), 
					'12' => esc_html__( '12', 'select-core'), 
					'13' => esc_html__( '13', 'select-core'), 
					'14' => esc_html__( '14', 'select-core'), 
					'15' => esc_html__( '15', 'select-core'), 
					'16' => esc_html__( '16', 'select-core'), 
					'17' => esc_html__( '17', 'select-core'), 
					'18' => esc_html__( '18', 'select-core'), 
					'19' => esc_html__( '19', 'select-core'), 
					'20' => esc_html__( '20', 'select-core'), 
					'21' => esc_html__( '21', 'select-core'), 
					'22' => esc_html__( '22', 'select-core'), 
					'23' => esc_html__( '23', 'select-core'), 
					'24' => esc_html__( '24', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'minute',
			[
				'label'     => esc_html__( 'Minute', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'0' => esc_html__( '0', 'select-core'), 
					'1' => esc_html__( '1', 'select-core'), 
					'2' => esc_html__( '2', 'select-core'), 
					'3' => esc_html__( '3', 'select-core'), 
					'4' => esc_html__( '4', 'select-core'), 
					'5' => esc_html__( '5', 'select-core'), 
					'6' => esc_html__( '6', 'select-core'), 
					'7' => esc_html__( '7', 'select-core'), 
					'8' => esc_html__( '8', 'select-core'), 
					'9' => esc_html__( '9', 'select-core'), 
					'10' => esc_html__( '10', 'select-core'), 
					'11' => esc_html__( '11', 'select-core'), 
					'12' => esc_html__( '12', 'select-core'), 
					'13' => esc_html__( '13', 'select-core'), 
					'14' => esc_html__( '14', 'select-core'), 
					'15' => esc_html__( '15', 'select-core'), 
					'16' => esc_html__( '16', 'select-core'), 
					'17' => esc_html__( '17', 'select-core'), 
					'18' => esc_html__( '18', 'select-core'), 
					'19' => esc_html__( '19', 'select-core'), 
					'20' => esc_html__( '20', 'select-core'), 
					'21' => esc_html__( '21', 'select-core'), 
					'22' => esc_html__( '22', 'select-core'), 
					'23' => esc_html__( '23', 'select-core'), 
					'24' => esc_html__( '24', 'select-core'), 
					'25' => esc_html__( '25', 'select-core'), 
					'26' => esc_html__( '26', 'select-core'), 
					'27' => esc_html__( '27', 'select-core'), 
					'28' => esc_html__( '28', 'select-core'), 
					'29' => esc_html__( '29', 'select-core'), 
					'30' => esc_html__( '30', 'select-core'), 
					'31' => esc_html__( '31', 'select-core'), 
					'32' => esc_html__( '32', 'select-core'), 
					'33' => esc_html__( '33', 'select-core'), 
					'34' => esc_html__( '34', 'select-core'), 
					'35' => esc_html__( '35', 'select-core'), 
					'36' => esc_html__( '36', 'select-core'), 
					'37' => esc_html__( '37', 'select-core'), 
					'38' => esc_html__( '38', 'select-core'), 
					'39' => esc_html__( '39', 'select-core'), 
					'40' => esc_html__( '40', 'select-core'), 
					'41' => esc_html__( '41', 'select-core'), 
					'42' => esc_html__( '42', 'select-core'), 
					'43' => esc_html__( '43', 'select-core'), 
					'44' => esc_html__( '44', 'select-core'), 
					'45' => esc_html__( '45', 'select-core'), 
					'46' => esc_html__( '46', 'select-core'), 
					'47' => esc_html__( '47', 'select-core'), 
					'48' => esc_html__( '48', 'select-core'), 
					'49' => esc_html__( '49', 'select-core'), 
					'50' => esc_html__( '50', 'select-core'), 
					'51' => esc_html__( '51', 'select-core'), 
					'52' => esc_html__( '52', 'select-core'), 
					'53' => esc_html__( '53', 'select-core'), 
					'54' => esc_html__( '54', 'select-core'), 
					'55' => esc_html__( '55', 'select-core'), 
					'56' => esc_html__( '56', 'select-core'), 
					'57' => esc_html__( '57', 'select-core'), 
					'58' => esc_html__( '58', 'select-core'), 
					'59' => esc_html__( '59', 'select-core'), 
					'60' => esc_html__( '60', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'month_label',
			[
				'label'     => esc_html__( 'Month Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__('Months', 'select-core')
			]
		);

		$this->add_control(
			'day_label',
			[
				'label'     => esc_html__( 'Day Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__('Days', 'select-core')
			]
		);

		$this->add_control(
			'hour_label',
			[
				'label'     => esc_html__( 'Hour Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__('Hours', 'select-core')
			]
		);

		$this->add_control(
			'minute_label',
			[
				'label'     => esc_html__( 'Minute Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__('Minutes', 'select-core')
			]
		);

		$this->add_control(
			'second_label',
			[
				'label'     => esc_html__( 'Second Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__('Seconds', 'select-core')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'design_options',
			[
				'label' => esc_html__( 'Design Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'digit_font_size',
			[
				'label'     => esc_html__( 'Digit Font Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'digit_color',
			[
				'label'     => esc_html__( 'Digit Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'label_font_size',
			[
				'label'     => esc_html__( 'Label Font Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'label_color',
			[
				'label'     => esc_html__( 'Label Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['id'] = mt_rand(1000, 9999);

		echo qodef_core_get_shortcode_template_part('templates/countdown-template', 'countdown', '', $params);

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorCountdown() );