<?php
namespace MixtapeQode\Modules\Shortcodes\Clients;

use MixtapeQode\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class Clients
 */

class Clients implements ShortcodeInterface{
	private $base;
	function __construct() {
		$this->base = 'qodef_clients';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Clients', 'select-core'),
			'base' => $this->base,
			'as_parent' => array('only' => 'qodef_client'),
			'content_element' => true,
			'category' => esc_html__('by SELECT', 'select-core'),
			'icon' => 'icon-wpb-clients extended-custom-icon',
			'show_settings_on_create' => true,
			'params' => array(
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__('Columns', 'select-core'),
					'param_name' => 'columns',
					'value' => array(
						esc_html__('Two', 'select-core')       => 'two-columns',
						esc_html__('Three', 'select-core')     => 'three-columns',
						esc_html__('Four', 'select-core')      => 'four-columns',
						esc_html__('Five', 'select-core')      => 'five-columns',
						esc_html__('Six', 'select-core')       => 'six-columns'
					),
					'save_always' => true,
					'description' => ''
				)
			),
			'js_view' => 'VcColumnView'

		));
	}

	public function render($atts, $content = null) {
	
		$args = array(
			'columns' 			=> ''
		);
		$params = shortcode_atts($args, $atts);
		extract($params);
		$params['content']= $content;
		$html						= '';

		$html = qodef_core_get_shortcode_template_part('templates/clients-template', 'clients', '', $params);

		return $html;

	}

}
