<?php
class SelectCoreElementorCallToAction extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_call_to_action'; 
	}

	public function get_title() {
		return esc_html__( 'Call To Action', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-call-to-action';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'full_width',
			[
				'label'     => esc_html__( 'Full Width', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'), 
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'content_in_grid',
			[
				'label'     => esc_html__( 'Content in grid', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'), 
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes',
				'condition' => [
					'full_width' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'grid_size',
			[
				'label'     => esc_html__( 'Grid size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'75' => esc_html__( '75/25', 'select-core'), 
					'50' => esc_html__( '50/50', 'select-core'), 
					'66' => esc_html__( '66/33', 'select-core')
				),
				'default' => '75',
				'condition' => [
					'content_in_grid' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'normal' => esc_html__( 'Normal', 'select-core'), 
					'with-icon' => esc_html__( 'With Icon', 'select-core')
				),
				'default' => 'normal'
			]
		);

		mixtape_qodef_icon_collections()->getElementorParamsArray( $this, array('type' => array('with-icon')), '', true );

		$this->add_control(
			'show_button',
			[
				'label'     => esc_html__( 'Show Button', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'), 
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'button_position',
			[
				'label'     => esc_html__( 'Button Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default/right', 'select-core'), 
					'center' => esc_html__( 'Center', 'select-core'), 
					'left' => esc_html__( 'Left', 'select-core')
				),
				'default' => 'right',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'     => esc_html__( 'Button Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default text is &quot;button&quot;', 'select-core' ),
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label'     => esc_html__( 'Button Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_target',
			[
				'label'     => esc_html__( 'Button Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'), 
					'_self' => esc_html__( 'Self', 'select-core'), 
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_icon_pack',
			[
				'label'     => esc_html__( 'Button Icon Pack', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array_merge(array('' => esc_html__('No Icon', 'select-core')),mixtape_qodef_icon_collections()->getIconCollections()),
				'default' => '',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);


		$call_to_action_button_IconCollections = mixtape_qodef_icon_collections()->iconCollections;
		foreach($call_to_action_button_IconCollections as $collection_key => $collection) {

			$this->add_control(
				'button_'.$collection->param,
				[
					'label'     => esc_html__( 'Button Icon', 'select-core' ),
					'type'      => \Elementor\Controls_Manager::SELECT,
					'options' => array_flip($collection->getIconsArray()),
					'default' => '',
					'condition' => [
						'button_icon_pack' => array( $collection_key)
					]
				]
			);
		}

		$this->add_control(
			'content',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'design_options',
			[
				'label' => esc_html__( 'Design Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label'     => esc_html__( 'Icon Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'type' => array( 'with-icon' )
				]
			]
		);

		$this->add_control(
			'box_padding',
			[
				'label'     => esc_html__( 'Box Padding (top right bottom left) px', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default padding is 20px on all sides', 'select-core' )
			]
		);

		$this->add_control(
			'text_size',
			[
				'label'     => esc_html__( 'Default Text Font Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Font size for p tag', 'select-core' )
			]
		);

		$this->add_control(
			'button_skin',
			[
				'label'     => esc_html__( 'Button Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'dark' => esc_html__( 'Dark', 'select-core'), 
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => 'dark',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_size',
			[
				'label'     => esc_html__( 'Button Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'), 
					'small' => esc_html__( 'Small', 'select-core'), 
					'medium' => esc_html__( 'Medium', 'select-core'), 
					'large' => esc_html__( 'Large', 'select-core'), 
					'big_large' => esc_html__( 'Extra Large', 'select-core')
				),
				'default' => '',
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();



		$params['content']= preg_replace('#^<\/p>|<p>$#', '', $params['content']);
		$params['text_wrapper_classes'] = $this->getTextWrapperClasses($params);
		$params['content_styles'] = $this->getContentStyles($params);
		$params['call_to_action_styles'] = $this->getCallToActionStyles($params);
		$params['icon'] = $this->getCallToActionIcon($params);
		$params['button_parameters'] = $this->getButtonParameters($params);
		$params['bg_style'] = $this->getBackgroundStyles($params);


		echo qodef_core_get_shortcode_template_part('templates/call-to-action-template', 'calltoaction', '', $params);


	}

	private function getTextWrapperClasses($params) {
		return ( $params['show_button'] == 'yes') ? 'qodef-call-to-action-column1 qodef-call-to-action-cell' : '';
	}

	private function getBackgroundStyles($params) {
		$bg_style = array();

		if ($params['bg_color'] !== '') {
			$bg_style[] = 'background-color: ' . $params['bg_color'];
		}

		return implode(';', $bg_style);
	}

	private function getIconStyles($params) {
		$icon_style = array();

		if ($params['icon_size'] !== '') {
			$icon_style[] = 'font-size: ' . $params['icon_size'] . 'px';
		}

		return implode(';', $icon_style);
	}

	private function getContentStyles($params) {
		$content_styles = array();

		if ($params['text_size'] !== '') {
			$content_styles[] = 'font-size: ' . $params['text_size'] . 'px';
		}

		return implode(';', $content_styles);
	}

	private function getCallToActionStyles($params) {
		$call_to_action_styles = array();

		if ($params['box_padding'] != '') {
			$call_to_action_styles[] = 'padding: ' . $params['box_padding'] . ';';
		}

		return implode(';', $call_to_action_styles);
	}

	private function getCallToActionIcon($params) {

		$icon = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);
		$iconStyles = array();
		$iconStyles['icon_attributes']['style'] = $this->getIconStyles($params);
		$call_to_action_icon = '';
		if(!empty($params[$icon])){			
			$call_to_action_icon = mixtape_qodef_icon_collections()->renderIcon( $params[$icon], $params['icon_pack'], $iconStyles );
		}
		return $call_to_action_icon;

	}

	private function getButtonParameters($params) {
		$button_params_array = array();
		
		if(!empty($params['button_link'])) {
			$button_params_array['link'] = $params['button_link'];
		}
		
		if(!empty($params['button_size'])) {
			$button_params_array['size'] = $params['button_size'];
		}

		if(!empty($params['button_skin'])) {
			$button_params_array['button_skin'] = $params['button_skin'];
		}
		
		if(!empty($params['button_icon_pack'])) {
			$button_params_array['icon_pack'] = $params['button_icon_pack'];
			$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($params['button_icon_pack']);
			$button_params_array[$iconPackName] = $params['button_'.$iconPackName];		
		}
				
		if(!empty($params['button_target'])) {
			$button_params_array['target'] = $params['button_target'];
		}
		
		if(!empty($params['button_text'])) {
			$button_params_array['text'] = $params['button_text'];
		}
		
		return $button_params_array;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorCallToAction() );