<?php
class SelectCoreElementorBlogSlider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_blog_slider'; 
	}

	public function get_title() {
		return esc_html__( 'Blog Slider', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-blog-slider';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label'     => esc_html__( 'Slider Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'carousel' => esc_html__( 'Carousel', 'select-core'), 
					'slider' => esc_html__( 'Slider', 'select-core')
				),
				'default' => 'carousel'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Leave empty for all posts', 'select-core' )
			]
		);

		$this->add_control(
			'selected_posts',
			[
				'label'     => esc_html__( 'Selected Posts', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Selected Posts (leave empty for all, delimit by comma)', 'select-core' )
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order by', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'select-core'), 
					'title' => esc_html__( 'Title', 'select-core')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'desc' => esc_html__( 'DESC', 'select-core'), 
					'asc' => esc_html__( 'ASC', 'select-core')
				),
				'default' => 'DESC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category IDs', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Leave empty for all or use comma for list', 'select-core' )
			]
		);

		$this->add_control(
			'show_image',
			[
				'label'     => esc_html__( 'Show Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'), 
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no',
				'condition' => [
					'slider_type' => array( 'carousel' )
				]
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'select-core'), 
					'square' => esc_html__( 'Square', 'select-core')
				),
				'default' => 'full',
				'condition' => [
					'show_image' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'image_size_slider',
			[
				'label'     => esc_html__( 'Image Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'select-core'), 
					'square' => esc_html__( 'Square', 'select-core'), 
					'custom' => esc_html__( 'Custom', 'select-core')
				),
				'default' => 'full',
				'condition' => [
					'slider_type' => array( 'slider' )
				]
			]
		);

		$this->add_control(
			'image_width',
			[
				'label'     => esc_html__( 'Image Width', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set custom image width', 'select-core' ),
				'condition' => [
					'image_size_slider' => array( 'custom' )
				]
			]
		);

		$this->add_control(
			'image_height',
			[
				'label'     => esc_html__( 'Image Height', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set custom image height', 'select-core' ),
				'condition' => [
					'image_size_slider' => array( 'custom' )
				]
			]
		);

		$this->add_control(
			'text_length',
			[
				'label'     => esc_html__( 'Text length', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of characters', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		extract($params);

		$args = array(
			'post_type'			=> 'post',
			'posts_per_page'	=> $number_of_posts,
			'orderby'			=> $order_by,
			'order'				=> $order
		);
		if($category != '' && $category != 0){
			$args['cat'] = $category;			
		}

		$slider_class = 'qodef-blog-slider-type-'.$slider_type;
		$post_ids = null;
		
		if($selected_posts != ''){
			$post_ids = explode(',', $selected_posts);
			$args['post__in'] = $post_ids;
		}

        if($slider_type == 'slider'){
           if($image_size_slider == 'custom' && $image_width != '' && $image_height != ''){
                $params['image_size_slider'] = 'custom';
                $params['image_width'] = $image_width;
                $params['image_height'] = $image_height;
            }elseif($image_size_slider == 'square') {
               $params['image_size_slider'] = 'mixtape_qodef_square';
           }



        }elseif($image_size == 'square') {
            $params['image_size'] = 'mixtape_qodef_square';
        }

		$query = new \WP_Query($args);

		if ( $query->have_posts() ) {

			$html = '';

			$html .= '<div class="qodef-blog-slider-outer">';
			

			$html .= '<div class="qodef-blog-slider qodef-slick-slider-navigation-style '. $slider_class .'" data-type="'.$slider_type.'">';

			while ( $query->have_posts() ) {

				$query->the_post();

				//Get slide HTML from template
				$html .= qodef_core_get_shortcode_template_part('templates/blog-'.$slider_type, 'blog-slider', '', $params);

			}

			$html .= '</div></div>';


		} else {

			$html = esc_html__('There is no posts!', 'select-core');

		}

		wp_reset_postdata();

		echo $html;

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorBlogSlider() );