<?php
class SelectCoreElementorBlogList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_blog_list'; 
	}

	public function get_title() {
		return esc_html__( 'Blog List', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-blog-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'boxes' => esc_html__( 'Boxes', 'select-core'),
					'minimal' => esc_html__( 'Minimal', 'select-core'),
					'masonry' => esc_html__( 'Masonry', 'select-core'),
					'image_in_box' => esc_html__( 'Image in box', 'select-core')
				),
				'default' => 'boxes'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'select-core'),
					'2' => esc_html__( 'Two', 'select-core'),
					'3' => esc_html__( 'Three', 'select-core'),
					'4' => esc_html__( 'Four', 'select-core')
				),
				'default' => '1',
				'condition' => [
					'type' => array( 'boxes' )
				]
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order By', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'title' => esc_html__( 'Title', 'select-core'),
					'date' => esc_html__( 'Date', 'select-core')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'select-core'),
					'DESC' => esc_html__( 'DESC', 'select-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category Slug', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Leave empty for all or use comma for list', 'select-core' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'original' => esc_html__( 'Original', 'select-core'),
					'landscape' => esc_html__( 'Landscape', 'select-core'),
					'square' => esc_html__( 'Square', 'select-core')
				),
				'default' => 'original',
				'condition' => [
					'type' => array( 'boxes' )
				]
			]
		);

		$this->add_control(
			'text_length',
			[
				'label'     => esc_html__( 'Text length', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of characters', 'select-core' ),
				'default'   => '90'
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'boxes', 'masonry' )
				]
			]
		);

		$this->add_control(
			'post_info_color',
			[
				'label'     => esc_html__( 'Post Info Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'boxes', 'masonry' )
				]
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'boxes', 'masonry' )
				]
			]
		);

		$this->add_control(
			'box_shadow',
			[
				'label'     => esc_html__( 'Box Shadow', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'boxes', 'masonry' )
				]
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'boxes', 'masonry' )
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h4',
				'condition' => [
					'type' => array( 'boxes', 'minimal', 'image_in_box' )
				]
			]
		);

		$this->add_control(
			'show_load_more',
			[
				'label'     => esc_html__( 'Show Load More', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'load_more_skin',
			[
				'label'     => esc_html__( 'Load More Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'dark' => esc_html__( 'Dark', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => 'dark',
				'condition' => [
					'show_load_more' => array( 'yes' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getBlogHolderClasses($params);
	
		$queryArray = $this->generateBlogQueryArray($params);
		$query_result = new \WP_Query($queryArray);
		$params['query_result'] = $query_result;	
		
        $thumbImageSize = $this->generateImageSize($params);
		$params['thumb_image_size'] = $thumbImageSize;

		$params['data_atts'] = $this->getDataAtts($params);
		$params['data_atts'] .= 'data-max-num-pages = '.$query_result->max_num_pages;


		$params['title_color'] = $this->getBlogListTitleColor($params);
		$params['post_info_color'] = $this->getBlogListPostInfoColor($params);
		$params['text_color'] = $this->getBlogListTextColor($params);
		$params['bg_color'] = $this->getHolderBackgroundColor($params);

		echo qodef_core_get_shortcode_template_part('templates/blog-list-holder', 'blog-list', '', $params);
		
	}

	private function getBlogHolderClasses($params){
		$holderClasses = '';
		
		$columnNumber = $this->getColumnNumberClass($params);
		
		if(!empty($params['type'])){
			switch($params['type']){
				case 'image_in_box':
					$holderClasses = 'qodef-image-in-box';
				break;
				case 'boxes' : 
					$holderClasses = 'qodef-boxes';
				break;	
				case 'masonry' : 
					$holderClasses = 'qodef-masonry';
				break;
				case 'minimal' :
					$holderClasses = 'qodef-minimal';
				break;
				default: 
					$holderClasses = 'qodef-boxes';
			}
		}
		
		$holderClasses .= ' '.$columnNumber;

        if(!empty($params['bg_color'])) {
            $holderClasses .= ' qodef-holder-with-padding';
        }

        if($params['box_shadow'] == 'yes') {
            $holderClasses .= ' qodef-holder-with-shadow';
            $holderClasses .= ' qodef-holder-with-padding';
        }

        if($params['load_more_skin'] == 'light') {
            $holderClasses .= ' qodef-holder-load-more-light';
        }

		return $holderClasses;
		
	}

	private function getColumnNumberClass($params){
		
		$columnsNumber = '';
		$type = $params['type'];
		$columns = $params['number_of_columns'];
		
        if ($type == 'boxes') {
            switch ($columns) {
                case 1:
                    $columnsNumber = 'qodef-one-column';
                    break;
                case 2:
                    $columnsNumber = 'qodef-two-columns';
                    break;
                case 3:
                    $columnsNumber = 'qodef-three-columns';
                    break;
                case 4:
                    $columnsNumber = 'qodef-four-columns';
                    break;
                default:
					$columnsNumber = 'qodef-one-column';
                    break;
            }
        }
		return $columnsNumber;
	}

	public function generateBlogQueryArray($params){

		$queryArray = array();
		
		$queryArray = array(
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'category_name' => $params['category']
		);

		$paged = '';
        if(empty($params['next_page'])) {
            if(get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif(get_query_var('page')) {
                $paged = get_query_var('page');
            }
        }

        if(!empty($params['next_page'])){
            $queryArray['paged'] = $params['next_page'];

        } else{
            $queryArray['paged'] = 1;
        }

		return $queryArray;
	}

	private function generateImageSize($params){
		$thumbImageSize = '';
		$imageSize = $params['image_size'];
		
		if ($imageSize !== '' && $imageSize == 'landscape') {
            $thumbImageSize .= 'mixtape_qodef_landscape';
        } else if($imageSize === 'square'){
			$thumbImageSize .= 'mixtape_qodef_square';
		} else if ($imageSize !== '' && $imageSize == 'original') {
            $thumbImageSize .= 'full';
        }
		return $thumbImageSize;
	}

	private function getBlogListTitleColor($params) {

		$title_color = array();

		if ($params['title_color'] !== '') {
			$title_color[] = 'color:' . $params['title_color'];
		}

		return implode(';', $title_color);
	}

	private function getBlogListPostInfoColor($params) {

		$post_info_color = array();

		if ($params['post_info_color'] !== '') {
			$post_info_color[] = 'color:' . $params['post_info_color'];
		}

		return implode(';', $post_info_color);
	}

	private function getBlogListTextColor($params) {

		$text_color = array();

		if ($params['text_color'] !== '') {
			$text_color[] = 'color:' . $params['text_color'];
		}

		return implode(';', $text_color);
	}

	private function getHolderBackgroundColor($params) {

		$bg_color = array();

		if ($params['bg_color'] !== '') {
			$bg_color[] = 'background-color:' . $params['bg_color'];
		}

		return implode(';', $bg_color);
	}

    public function getDataAtts($params){

        $data_attr = array();
        $data_return_string = '';

        if(get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif(get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }

        if(!empty($paged)) {
            $data_attr['data-next-page'] = $paged+1;
        }
        if(!empty($params['order_by'])){
            $data_attr['data-order-by'] = $params['order_by'];
        }
        if(!empty($params['order'])){
            $data_attr['data-order'] = $params['order'];
        }
        if(!empty($params['number_of_posts'])){
            $data_attr['data-number'] = $params['number_of_posts'];
        }
        if(!empty($params['title_tag'])){
            $data_attr['data-title-tag'] = $params['title_tag'];
        }
        if(!empty($params['title_color'])){
            $data_attr['data-title-color'] = $params['title_color'];
        }
        if(!empty($params['text_color'])){
            $data_attr['data-text-color'] = $params['text_color'];
        }
        if(!empty($params['post_info_color'])){
            $data_attr['data-post-info-color'] = $params['post_info_color'];
        }
        if(!empty($params['box_shadow'])){
            $data_attr['data-box-shadow'] = $params['box_shadow'];
        }
        if(!empty($params['bg_color'])){
            $data_attr['data-bg-color'] = $params['bg_color'];
        }
        if(!empty($params['show_load_more'])){
            $data_attr['data-show-load-more'] = $params['show_load_more'];
        }
        if(!empty($params['load_more_skin'])){
            $data_attr['data-load-more-skin'] = $params['load_more_skin'];
        }
        if(!empty($params['text_length'])){
            $data_attr['data-text-length'] = $params['text_length'];
        }
        if(!empty($params['category'])){
            $data_attr['data-category'] = $params['category'];
        }
        if(!empty($params['image-size'])){
            $data_attr['data-image-size'] = $params['image-size'];
        }
        if(!empty($params['type'])){
            $data_attr['data-type'] = $params['type'];
        }
        
        foreach($data_attr as $key => $value) {
            if($key !== '') {
                $data_return_string .= $key . '= "' . esc_attr( $value ) . '" ';
            }
        }
        return $data_return_string;
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorBlogList() );