<?php
class SelectCoreElementorBanner extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_banner'; 
	}

	public function get_title() {
		return esc_html__( 'Banner', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-banner';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'item_image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'banner_title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'text_skin',
			[
				'label'     => esc_html__( 'Text Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'light' => esc_html__( 'Light', 'select-core'),
					'dark' => esc_html__( 'Dark', 'select-core')
				),
				'default' => 'light',
				'condition' => [
					'banner_title!' => ''
				]
			]
		);

		$this->add_control(
			'image_hover',
			[
				'label'     => esc_html__( 'Image Hover', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'No Hover', 'select-core'),
					'zoom' => esc_html__( 'Zoom', 'select-core')
				),
				'default' => '',
				'condition' => [
					'item_image!' => ''
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['item_image']     = !empty($params['item_image']) ? $params['item_image']['id'] : $params['item_image'];
		$params['banner_classes'] = $this->getBannerClass($params);

        if($params['link_target'] == ''){
            $params['link_target'] = '_self';
        }

		echo qodef_core_get_shortcode_template_part('templates/banner-template', 'banner', '', $params);

	}

    private function getBannerClass($params) {

        $banner_classes = array();

	    if( !empty($params['text_skin']) && $params['text_skin'] === 'dark') {
		    $banner_classes[] = 'qodef-bih-dark-text';
	    }
        
        if( !empty($params['image_hover']) ) {
            $banner_classes[] = 'qodef-bih-'.$params['image_hover'];
        }

        return implode(' ', $banner_classes);

    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorBanner() );