<?php
class SelectCoreElementorAnchorMenu extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_anchor_menu'; 
	}

	public function get_title() {
		return esc_html__( 'Anchor Menu', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-anchor-menu';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'label',
			[
				'label'     => esc_html__( 'Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'anchor',
			[
				'label'     => esc_html__( 'Link with anchor', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'menu_items',
			[
				'label'     => esc_html__( 'Menu Items', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		echo qodef_core_get_shortcode_template_part('templates/anchor-menu-template', 'anchor-menu', '', $params);

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAnchorMenu() );