<?php
class SelectCoreElementorTestimonials extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_testimonials'; 
	}

	public function get_title() {
		return esc_html__( 'Testimonials', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-testimonials';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Category Slug (leave empty for all)', 'select-core' )
			]
		);

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of Testimonials', 'select-core' )
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'     => esc_html__( 'Show Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_author',
			[
				'label'     => esc_html__( 'Show Author', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_position',
			[
				'label'     => esc_html__( 'Show Author Job Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes',
				'condition' => [
					'show_author' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'animation_speed',
			[
				'label'     => esc_html__( 'Animation speed', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Speed of slide animation in miliseconds', 'select-core' )
			]
		);

		$this->add_control(
			'arrows_navigation',
			[
				'label'     => esc_html__( 'Show Arrows navigation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'dots_navigation',
			[
				'label'     => esc_html__( 'Show Dots navigation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$type   = 'simple';
        $number = esc_attr($params['number']);
        $category = esc_attr($params['category']);
        $animation_speed = esc_attr($params['animation_speed']);
		
		$data_attr = $this->getDataParams($params);
		$query_args = $this->getQueryParams($params);
		?>

        <div class="qodef-testimonials-holder clearfix">
            <div class="qodef-slick-slider-navigation-style qodef-testimonials qodef-testimonials-type-'<?php echo esc_attr($type); ?>" <?php echo esc_html($data_attr); ?>>
				<?php
			        query_posts($query_args);
			        if (have_posts()) :
			            while (have_posts()) : the_post();
			                $author = get_post_meta(get_the_ID(), 'qodef_testimonial_author', true);
			                $text = get_post_meta(get_the_ID(), 'qodef_testimonial_text', true);
			                $title = get_post_meta(get_the_ID(), 'qodef_testimonial_title', true);
			                $job = get_post_meta(get_the_ID(), 'qodef_testimonial_author_position', true);

							$params['author'] = $author;
							$params['text'] = $text;
							$params['title'] = $title;
							$params['job'] = $job;
							$params['current_id'] = get_the_ID();
								echo qodef_core_get_cpt_shortcode_template_part('testimonials', $type . '-testimonials-template', '', $params);
			            endwhile;
			        else:
			             esc_html_e('Sorry, no posts matched your criteria.', 'qodef-cpt');
			        endif;

                    wp_reset_query(); ?>
	            </div>
			</div>

	<?php }

	private function getDataParams($params){
		$data_attr = '';
		
		if(!empty($params['animation_speed'])){
			$data_attr .= ' data-animation-speed ="' . $params['animation_speed'] . '"';
		}

		if(!empty($params['arrows_navigation']) && $params['arrows_navigation'] == 'no'){
			$data_attr .= ' data-arrows-navigation ="false"';
		}

		if(!empty($params['dots_navigation']) && $params['dots_navigation'] == 'no'){
			$data_attr .= ' data-dots-navigation ="false"';
		}
		
		return $data_attr;
	}

	private function getQueryParams($params){
		
		$args = array(
            'post_type' => 'testimonials',
            'orderby' => 'date',
            'order' => 'DESC',
            'posts_per_page' => $params['number']
        );

        if ($params['category'] != '') {
            $args['testimonials_category'] = $params['category'];
        }

		return $args;

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorTestimonials() );