<?php
class SelectCoreElementorAlbum extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_album'; 
	}

	public function get_title() {
		return esc_html__( 'Album', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-album';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'album',
			[
				'label'     => esc_html__( 'Album', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array_flip($this->getAlbums()),
				'default' => ''
			]
		);

		$this->add_control(
			'album_skin',
			[
				'label'     => esc_html__( 'Album Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'dark' => esc_html__( 'Dark', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => ''
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['alb_skin'] = $this->getAlbumClasses($params);

		$params['random_id'] = 'qodef-album-id-'.rand();
		$params['tracks'] = $this->getTracks($params);

		echo qodef_core_get_cpt_shortcode_template_part('albums','album-template', '', $params);

	}

	private function getAlbums(){

		$albums_array = array();
		$args = array(
			'post_type'			=> 'album',
			'posts_per_page'	=> '-1'
		);

		$query = new \WP_Query($args);
		if($query->have_posts()) :
			while($query->have_posts()) : $query->the_post();
				$albums_array[get_the_ID()] = get_the_title();
			endwhile;
		endif;

		return  array_flip($albums_array);
	}

	private function getTracks($params){

		$tracks_array = array();
		$tracks = get_post_meta($params['album'], 'qodef_track_file', true);
		$titles = get_post_meta($params['album'], 'qodef_track_title', true);
		$videos = get_post_meta($params['album'], 'qodef_track_video_link', true);
		$free_download = get_post_meta($params['album'], 'qodef_track_free_download', true);

		$i = 0;

		if($tracks){
			foreach($tracks as $track){
				/*------------------------------------------------------------------------------------------*/
				//if import is executed second time and file does exists in 'uploads' but not in database
				//usercase ex: user empties db, but not 'uploads' folder
				if(qodef_core_get_attachment_id_from_url($track) == null){
					$i++;
					continue;
				}
				/*------------------------------------------------------------------------------------------*/

				$tracks_array[$i]['track_file'] = $track;
				$track_id = qodef_core_get_attachment_id_from_url($track);

				$track_data = wp_get_attachment_metadata($track_id);
				$tracks_array[$i]['track_time'] = $track_data['length_formatted'];
				if(isset($videos[$i])){
					$tracks_array[$i]['video_link'] = $videos[$i];
				}

				if(isset($titles[$i])){
					$tracks_array[$i]['title']	= $titles[$i];
				}

				if(isset($free_download[$i]) && $free_download[$i] != ''){
					$tracks_array[$i]['free_download']	= $free_download[$i];
				}
				$i++;
			}
		}
		return  $tracks_array;
	}

	private function getAlbumClasses($params) {

		$album_classes = array();

		if ($params['album_skin'] == 'light') {
			$album_classes[] = 'qodef-album-light';
		} else if ($params['album_skin'] == 'dark') {
			$album_classes[] = 'qodef-album-dark';
		}

		return implode(';', $album_classes);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAlbum() );