(function ($) {
    "use strict";

    var header = {};
    qodef.modules.header = header;

    header.isStickyVisible = false;
    header.stickyAppearAmount = 0;
    header.behaviour;
    header.qodefSideArea = qodefSideArea;
    header.qodefSideAreaScroll = qodefSideAreaScroll;
    header.qodefFullscreenMenu = qodefFullscreenMenu;
    header.qodefInitMobileNavigation = qodefInitMobileNavigation;
    header.qodefMobileHeaderBehavior = qodefMobileHeaderBehavior;
    header.qodefSetDropDownMenuPosition = qodefSetDropDownMenuPosition;
    header.qodefDropDownMenu = qodefDropDownMenu;
    header.qodefSearch = qodefSearch;
    header.qodefVerticalMenuScroll = qodefVerticalMenuScroll;
    header.qodefMenuLine = qodefMenuLine;

    header.qodefOnDocumentReady = qodefOnDocumentReady;
    header.qodefOnWindowLoad = qodefOnWindowLoad;
    header.qodefOnWindowResize = qodefOnWindowResize;
    header.qodefOnWindowScroll = qodefOnWindowScroll;

    $(document).ready(qodefOnDocumentReady);
    $(window).on('load', qodefOnWindowLoad);
    $(window).resize(qodefOnWindowResize);
    $(window).scroll(qodefOnWindowScroll);

    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function qodefOnDocumentReady() {
        qodefHeaderBehaviour();
        qodefSideArea();
        qodefSideAreaScroll();
        qodefFullscreenMenu();
        qodefInitMobileNavigation();
        qodefMobileHeaderBehavior();
        qodefSetDropDownMenuPosition();
        qodefDropDownMenu();
        qodefSearch();
        //qodefVerticalMenuScroll();
        qodefVerticalMenu().init();
        qodefInitDividedHeaderMenu();
        qodefMenuLine();
    }

    /* 
        All functions to be called on $(window).load() should be in this function
    */
    function qodefOnWindowLoad() {
        qodefDropDownMenu();
        qodefSetDropDownMenuPosition();
    }

    /* 
        All functions to be called on $(window).resize() should be in this function
    */
    function qodefOnWindowResize() {
        qodefInitDividedHeaderMenu();
        qodefDropDownMenu();
    }

    /* 
        All functions to be called on $(window).scroll() should be in this function
    */
    function qodefOnWindowScroll() {

    }


    /*
     **	Show/Hide sticky header on window scroll
     */
    function qodefHeaderBehaviour() {

        var header = $('.qodef-page-header');
        var stickyHeader = $('.qodef-sticky-header');
        var fixedHeaderWrapper = $('.qodef-fixed-wrapper');

        var headerMenuAreaOffset = $('.qodef-page-header').find('.qodef-fixed-wrapper').length ? $('.qodef-page-header').find('.qodef-fixed-wrapper').offset().top : null;

        var stickyAppearAmount;


        switch (true) {
            // sticky header that will be shown when user scrolls up
            case qodef.body.hasClass('qodef-sticky-header-on-scroll-up'):
                qodef.modules.header.behaviour = 'qodef-sticky-header-on-scroll-up';
                var docYScroll1 = $(document).scrollTop();
                stickyAppearAmount = qodefGlobalVars.vars.qodefTopBarHeight + qodefGlobalVars.vars.qodefLogoAreaHeight + qodefGlobalVars.vars.qodefMenuAreaHeight + qodefGlobalVars.vars.qodefStickyHeaderHeight;

                var headerAppear = function () {
                    var docYScroll2 = $(document).scrollTop();

                    if ((docYScroll2 > docYScroll1 && docYScroll2 > stickyAppearAmount) || (docYScroll2 < stickyAppearAmount)) {
                        qodef.modules.header.isStickyVisible = false;
                        stickyHeader.removeClass('header-appear').find('.qodef-main-menu .qodef-menu-second').removeClass('qodef-drop-down-start');
                    } else {
                        qodef.modules.header.isStickyVisible = true;
                        stickyHeader.addClass('header-appear');
                    }

                    docYScroll1 = $(document).scrollTop();
                };
                headerAppear();

                $(window).scroll(function () {
                    headerAppear();
                });

                break;

            // sticky header that will be shown when user scrolls both up and down
            case qodef.body.hasClass('qodef-sticky-header-on-scroll-down-up'):
                qodef.modules.header.behaviour = 'qodef-sticky-header-on-scroll-down-up';

                if (qodefPerPageVars.vars.qodefStickyScrollAmount !== 0) {
                    qodef.modules.header.stickyAppearAmount = qodefPerPageVars.vars.qodefStickyScrollAmount;
                } else {
                    qodef.modules.header.stickyAppearAmount = qodefGlobalVars.vars.qodefStickyScrollAmount !== 0 ? qodefGlobalVars.vars.qodefStickyScrollAmount : qodefGlobalVars.vars.qodefTopBarHeight + qodefGlobalVars.vars.qodefLogoAreaHeight + qodefGlobalVars.vars.qodefMenuAreaHeight;
                }

                var headerAppear = function () {
                    if (qodef.scroll < qodef.modules.header.stickyAppearAmount) {
                        qodef.modules.header.isStickyVisible = false;
                        stickyHeader.removeClass('header-appear').find('.qodef-main-menu .qodef-menu-second').removeClass('qodef-drop-down-start');
                    } else {
                        qodef.modules.header.isStickyVisible = true;
                        stickyHeader.addClass('header-appear');
                    }
                };

                headerAppear();

                $(window).scroll(function () {
                    headerAppear();
                });

                break;

            // on scroll down, part of header will be sticky
            case qodef.body.hasClass('qodef-fixed-on-scroll'):
                qodef.modules.header.behaviour = 'qodef-fixed-on-scroll';
                var headerFixed = function () {
                    if (qodef.scroll < headerMenuAreaOffset) {
                        fixedHeaderWrapper.removeClass('fixed');
                        header.css('margin-bottom', 0);
                    } else {
                        fixedHeaderWrapper.addClass('fixed');
                        header.css('margin-bottom', fixedHeaderWrapper.height());
                    }
                };

                headerFixed();

                $(window).scroll(function () {
                    headerFixed();
                });

                break;
        }
    }

    /**
     * Show/hide side area
     */
    function qodefSideArea() {

        var wrapper = $('.qodef-wrapper'),
            sideMenu = $('.qodef-side-menu'),
            sideMenuButtonOpen = $('a.qodef-side-menu-button-opener'),
            cssClass,
            //Flags
            slideFromRight = false,
            slideWithContent = false,
            slideUncovered = false;

        if (qodef.body.hasClass('qodef-side-menu-slide-from-right')) {
            $('.qodef-cover').remove();
            cssClass = 'qodef-right-side-menu-opened';
            wrapper.prepend('<div class="qodef-cover"/>');
            slideFromRight = true;

        } else if (qodef.body.hasClass('qodef-side-menu-slide-with-content')) {

            cssClass = 'qodef-side-menu-open';
            slideWithContent = true;

        } else if (qodef.body.hasClass('qodef-side-area-uncovered-from-content')) {

            cssClass = 'qodef-right-side-menu-opened';
            slideUncovered = true;

        }

        $('a.qodef-side-menu-button-opener, a.qodef-close-side-menu').on('click', function (e) {
            e.preventDefault();

            if (!sideMenuButtonOpen.hasClass('opened')) {

                sideMenuButtonOpen.addClass('opened');
                qodef.body.addClass(cssClass);

                if (slideFromRight) {
                    $('.qodef-wrapper .qodef-cover').on('click', function () {
                        qodef.body.removeClass('qodef-right-side-menu-opened');
                        sideMenuButtonOpen.removeClass('opened');
                    });
                }

                if (slideUncovered) {
                    sideMenu.css({
                        'visibility': 'visible'
                    });
                }

                var currentScroll = $(window).scrollTop();
                $(window).scroll(function () {
                    if (Math.abs(qodef.scroll - currentScroll) > 400) {
                        qodef.body.removeClass(cssClass);
                        sideMenuButtonOpen.removeClass('opened');
                        if (slideUncovered) {
                            var hideSideMenu = setTimeout(function () {
                                sideMenu.css({'visibility': 'hidden'});
                                clearTimeout(hideSideMenu);
                            }, 400);
                        }
                    }
                });

            } else {

                sideMenuButtonOpen.removeClass('opened');
                qodef.body.removeClass(cssClass);
                if (slideUncovered) {
                    var hideSideMenu = setTimeout(function () {
                        sideMenu.css({'visibility': 'hidden'});
                        clearTimeout(hideSideMenu);
                    }, 400);
                }

            }

            if (slideWithContent) {

                e.stopPropagation();
                wrapper.on('click', function () {
                    e.preventDefault();
                    sideMenuButtonOpen.removeClass('opened');
                    qodef.body.removeClass('qodef-side-menu-open');
                });

            }

        });

    }

    /*
    **  Smooth scroll functionality for Side Area
    */
    function qodefSideAreaScroll() {

        var sideMenu = $('.qodef-side-menu');

        if (sideMenu.length) {
            sideMenu.niceScroll({
                scrollspeed: 60,
                mousescrollstep: 40,
                cursorwidth: 0,
                cursorborder: 0,
                cursorborderradius: 0,
                cursorcolor: "transparent",
                autohidemode: false,
                horizrailenabled: false
            });
        }
    }

    /**
     * Init Fullscreen Menu
     */
    function qodefFullscreenMenu() {

        if ($('a.qodef-fullscreen-menu-opener').length) {

            var popupMenuOpener = $('a.qodef-fullscreen-menu-opener'),
                popupMenuHolderOuter = $(".qodef-fullscreen-menu-holder-outer"),
                cssClass,
                //Flags for type of animation
                fadeRight = false,
                fadeTop = false,
                //Widgets
                widgetAboveNav = $('.qodef-fullscreen-above-menu-widget-holder'),
                widgetBelowNav = $('.qodef-fullscreen-below-menu-widget-holder'),
                //Menu
                menuItems = $('.qodef-fullscreen-menu-holder-outer nav > ul > li > a'),
                menuItemWithChild = $('.qodef-fullscreen-menu > ul li.qodef-has-sub > a'),
                menuItemWithoutChild = $('.qodef-fullscreen-menu ul li:not(.qodef-has-sub) a');


            //set height of popup holder and initialize nicescroll
            popupMenuHolderOuter.height(qodef.windowHeight).niceScroll({
                scrollspeed: 30,
                mousescrollstep: 20,
                cursorwidth: 0,
                cursorborder: 0,
                cursorborderradius: 0,
                cursorcolor: "transparent",
                autohidemode: false,
                horizrailenabled: false
            }); //200 is top and bottom padding of holder

            //set height of popup holder on resize
            $(window).resize(function () {
                popupMenuHolderOuter.height(qodef.windowHeight);
            });

            if (qodef.body.hasClass('qodef-fade-push-text-right')) {
                cssClass = 'qodef-push-nav-right';
                fadeRight = true;
            } else if (qodef.body.hasClass('qodef-fade-push-text-top')) {
                cssClass = 'qodef-push-text-top';
                fadeTop = true;
            }

            //Appearing animation
            if (fadeRight || fadeTop) {
                if (widgetAboveNav.length) {
                    widgetAboveNav.children().css({
                        '-webkit-animation-delay': 0 + 'ms',
                        '-moz-animation-delay': 0 + 'ms',
                        'animation-delay': 0 + 'ms'
                    });
                }
                menuItems.each(function (i) {
                    $(this).css({
                        '-webkit-animation-delay': (i + 1) * 70 + 'ms',
                        '-moz-animation-delay': (i + 1) * 70 + 'ms',
                        'animation-delay': (i + 1) * 70 + 'ms'
                    });
                });
                if (widgetBelowNav.length) {
                    widgetBelowNav.children().css({
                        '-webkit-animation-delay': (menuItems.length + 1) * 70 + 'ms',
                        '-moz-animation-delay': (menuItems.length + 1) * 70 + 'ms',
                        'animation-delay': (menuItems.length + 1) * 70 + 'ms'
                    });
                }
            }

            // Open popup menu
            popupMenuOpener.on('click', function (e) {
                e.preventDefault();

                if (!popupMenuOpener.hasClass('opened')) {
                    popupMenuOpener.addClass('opened');
                    qodef.body.addClass('qodef-fullscreen-menu-opened');
                    qodef.body.removeClass('qodef-fullscreen-fade-out').addClass('qodef-fullscreen-fade-in');
                    qodef.body.removeClass(cssClass);
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefDisableScroll();
                    }
                    $(document).keyup(function (e) {
                        if (e.keyCode === 27) {
                            popupMenuOpener.removeClass('opened');
                            qodef.body.removeClass('qodef-fullscreen-menu-opened');
                            qodef.body.removeClass('qodef-fullscreen-fade-in').addClass('qodef-fullscreen-fade-out');
                            qodef.body.addClass(cssClass);
                            if (!qodef.body.hasClass('page-template-full_screen-php')) {
                                qodef.modules.common.qodefEnableScroll();
                            }
                            $("nav.qodef-fullscreen-menu ul.sub_menu").slideUp(200, function () {
                                $('nav.popup_menu').getNiceScroll().resize();
                            });
                        }
                    });
                } else {
                    popupMenuOpener.removeClass('opened');
                    qodef.body.removeClass('qodef-fullscreen-menu-opened');
                    qodef.body.removeClass('qodef-fullscreen-fade-in').addClass('qodef-fullscreen-fade-out');
                    qodef.body.addClass(cssClass);
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefEnableScroll();
                    }
                    $("nav.qodef-fullscreen-menu ul.sub_menu").slideUp(200, function () {
                        $('nav.popup_menu').getNiceScroll().resize();
                    });
                }
            });

            //logic for open sub menus in popup menu
            menuItemWithChild.on('tap click', function (e) {
                e.preventDefault();

                if ($(this).parent().hasClass('qodef-has-sub')) {
                    var submenu = $(this).parent().find('> ul.sub_menu');
                    if (submenu.is(':visible')) {
                        submenu.slideUp(200, function () {
                            popupMenuHolderOuter.getNiceScroll().resize();
                        });
                        $(this).parent().removeClass('open_sub');
                    } else {
                        if ($(this).parent().siblings().hasClass('open_sub')) {
                            $(this).parent().siblings().each(function () {
                                var sibling = $(this);
                                if (sibling.hasClass('open_sub')) {
                                    var openedUl = sibling.find('> ul.sub_menu');
                                    openedUl.slideUp(200, function () {
                                        popupMenuHolderOuter.getNiceScroll().resize();
                                    });
                                    sibling.removeClass('open_sub');
                                }
                                if (sibling.find('.open_sub')) {
                                    var openedUlUl = sibling.find('.open_sub').find('> ul.sub_menu');
                                    openedUlUl.slideUp(200, function () {
                                        popupMenuHolderOuter.getNiceScroll().resize();
                                    });
                                    sibling.find('.open_sub').removeClass('open_sub');
                                }
                            });
                        }

                        $(this).parent().addClass('open_sub');
                        submenu.slideDown(200, function () {
                            popupMenuHolderOuter.getNiceScroll().resize();
                        });
                    }
                }
                return false;
            });

            //if link has no submenu and if it's not dead, than open that link
            menuItemWithoutChild.on('click', function (e) {

                if (($(this).attr('href') !== "http://#") && ($(this).attr('href') !== "#")) {

                    if (e.which === 1) {
                        popupMenuOpener.removeClass('opened');
                        qodef.body.removeClass('qodef-fullscreen-menu-opened');
                        qodef.body.removeClass('qodef-fullscreen-fade-in').addClass('qodef-fullscreen-fade-out');
                        qodef.body.addClass(cssClass);
                        $("nav.qodef-fullscreen-menu ul.sub_menu").slideUp(200, function () {
                            $('nav.popup_menu').getNiceScroll().resize();
                        });
                        qodef.modules.common.qodefEnableScroll();
                    }
                } else {
                    return false;
                }

            });

        }


    }

    /**
     * Init Divided Header Menu
     */
    function qodefInitDividedHeaderMenu() {
        if (qodef.body.hasClass('qodef-header-divided')) {
            //get left side menu width
            var menuArea = $('.qodef-menu-area'),
                stickyArea = $('.qodef-sticky-holder'),
                menuAreaWidth = menuArea.width(),
                stickyAreaWidth = stickyArea.width(),
                menuAreaItem = $('.qodef-main-menu > ul > li > a'),
                menuItemPadding = 0,
                logoArea = menuArea.find('.qodef-logo-wrapper .qodef-normal-logo'),
                logoAreaWidth = 0;

            if (menuArea.children('.qodef-grid').length) {
                menuAreaWidth = menuArea.children('.qodef-grid').outerWidth();
            }

            if (stickyArea.children('.qodef-grid').length) {
                stickyAreaWidth = stickyArea.children('.qodef-grid').outerWidth();
            }

            if (menuAreaItem.length) {
                menuItemPadding = parseInt(menuAreaItem.css('padding-left'));
            }

            if (logoArea.length) {
                logoAreaWidth = logoArea.width() / 2;
            }

            var menuAreaLeftRightSideWidth = Math.round(menuAreaWidth / 2 - menuItemPadding - logoAreaWidth);
            var stickyAreaLeftRightSideWidth = Math.round(stickyAreaWidth / 2 - menuItemPadding - logoAreaWidth);

            $('.qodef-menu-area .qodef-position-left').width(menuAreaLeftRightSideWidth);
            $('.qodef-menu-area .qodef-position-right').width(menuAreaLeftRightSideWidth);

            $('.qodef-sticky-header .qodef-position-left').width(stickyAreaLeftRightSideWidth);
            $('.qodef-sticky-header .qodef-position-right').width(stickyAreaLeftRightSideWidth);

            menuArea.find('nav').css('opacity', 1);
        }
    }

    function qodefInitMobileNavigation() {
        var navigationOpener = $('.qodef-mobile-header .qodef-mobile-menu-opener');
        var navigationHolder = $('.qodef-mobile-header .qodef-mobile-nav');
        var dropdownOpener = $('.qodef-mobile-nav .mobile_arrow, .qodef-mobile-nav h4, .qodef-mobile-nav a[href*="#"]');
        var animationSpeed = 200;

        //whole mobile menu opening / closing
        if (navigationOpener.length && navigationHolder.length) {
            navigationOpener.on('tap click', function (e) {
                e.stopPropagation();
                e.preventDefault();

                if (navigationHolder.is(':visible')) {
                    navigationHolder.slideUp(animationSpeed);
                } else {
                    navigationHolder.slideDown(animationSpeed);
                }
            });
        }

        //dropdown opening / closing
        if (dropdownOpener.length) {
            dropdownOpener.each(function () {
                $(this).on('tap click', function (e) {
                    var dropdownToOpen = $(this).nextAll('ul').first();

                    if (dropdownToOpen.length) {
                        e.preventDefault();
                        e.stopPropagation();

                        var openerParent = $(this).parent('li');
                        if (dropdownToOpen.is(':visible')) {
                            dropdownToOpen.slideUp(animationSpeed);
                            openerParent.removeClass('qodef-opened');
                        } else {
                            dropdownToOpen.slideDown(animationSpeed);
                            openerParent.addClass('qodef-opened');
                        }
                    }

                });
            });
        }

        $('.qodef-mobile-nav a, .qodef-mobile-logo-wrapper a').on('click tap', function (e) {
            if ($(this).attr('href') !== 'http://#' && $(this).attr('href') !== '#') {
                navigationHolder.slideUp(animationSpeed);
            }
        });
    }

    function qodefMobileHeaderBehavior() {
        if (qodef.body.hasClass('qodef-sticky-up-mobile-header')) {
            var stickyAppearAmount;
            var topBar = $('.qodef-top-bar');
            var mobileHeader = $('.qodef-mobile-header');
            var adminBar = $('#wpadminbar');
            var mobileHeaderHeight = mobileHeader.length ? mobileHeader.height() : 0;
            var topBarHeight = topBar.is(':visible') ? topBar.height() : 0;
            var adminBarHeight = adminBar.length ? adminBar.height() : 0;

            var docYScroll1 = $(document).scrollTop();
            stickyAppearAmount = topBarHeight + mobileHeaderHeight + adminBarHeight;

            $(window).scroll(function () {
                var docYScroll2 = $(document).scrollTop();

                if (docYScroll2 > stickyAppearAmount) {
                    mobileHeader.addClass('qodef-animate-mobile-header');
                    mobileHeader.css('margin-bottom', mobileHeaderHeight);
                } else {
                    mobileHeader.removeClass('qodef-animate-mobile-header');
                    mobileHeader.css('margin-bottom', 0);
                }

                if ((docYScroll2 > docYScroll1 && docYScroll2 > stickyAppearAmount) || (docYScroll2 < stickyAppearAmount)) {
                    mobileHeader.removeClass('mobile-header-appear');
                    if (adminBar.length) {
                        mobileHeader.find('.qodef-mobile-header-inner').css('top', 0);
                    }
                } else {
                    mobileHeader.addClass('mobile-header-appear');

                }

                docYScroll1 = $(document).scrollTop();
            });
        }
    }

    /**
     * Set dropdown position
     */
    function qodefSetDropDownMenuPosition() {

        var menuItems = $(".qodef-drop-down > ul > li.qodef-menu-narrow");
        menuItems.each(function (i) {

            var browserWidth = qodef.windowWidth - 16; // 16 is width of scroll bar
            var menuItemPosition = $(this).offset().left;
            var dropdownMenuWidth = $(this).find('.qodef-menu-second .qodef-menu-inner ul').width();

            var menuItemFromLeft = 0;
            if (qodef.body.hasClass('boxed')) {
                menuItemFromLeft = qodef.boxedLayoutWidth - (menuItemPosition - (browserWidth - qodef.boxedLayoutWidth) / 2);
            } else {
                menuItemFromLeft = browserWidth - menuItemPosition;
            }

            var dropDownMenuFromLeft; //has to stay undefined beacuse 'dropDownMenuFromLeft < dropdownMenuWidth' condition will be true

            if ($(this).find('li.qodef-sub').length > 0) {
                dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
            }

            if (menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth) {
                $(this).find('.qodef-menu-second').addClass('right');
                $(this).find('.qodef-menu-second .qodef-menu-inner ul').addClass('right');
            }
        });

    }


    function qodefDropDownMenu() {

        var menu_items = $('.qodef-drop-down > ul > li');

        menu_items.each(function (i) {
            if ($(menu_items[i]).find('.qodef-menu-second').length > 0) {

                var dropDownSecondDiv = $(menu_items[i]).find('.qodef-menu-second');

                if ($(menu_items[i]).hasClass('qodef-menu-wide')) {

                    var dropdown = $(this).find('.qodef-menu-inner > ul');
                    var dropdownPadding = parseInt(dropdown.css('padding-left').slice(0, -2)) + parseInt(dropdown.css('padding-right').slice(0, -2));
                    var dropdownWidth = dropdown.outerWidth();

                    if (!$(this).hasClass('qodef-menu-left-position') && !$(this).hasClass('qodef-menu-right-position')) {
                        dropDownSecondDiv.css('left', 0);
                    }

                    //set columns to be same height - start
                    var tallest = 0;
                    $(this).find('.qodef-menu-second > .qodef-menu-inner > ul > li').each(function () {
                        var thisHeight = $(this).height();
                        if (thisHeight > tallest) {
                            tallest = thisHeight;
                        }
                    });
                    $(this).find('.qodef-menu-second > .qodef-menu-inner > ul > li').css("height", ""); // delete old inline css - via resize
                    $(this).find('.qodef-menu-second > .qodef-menu-inner > ul > li').height(tallest);
                    //set columns to be same height - end

                    if (!$(this).hasClass('qodef-wide-background')) {
                        if (!$(this).hasClass('qodef-menu-left-position') && !$(this).hasClass('qodef-menu-right-position')) {
                            var left_position = (qodef.windowWidth - 2 * (qodef.windowWidth - dropdown.offset().left)) / 2 + (dropdownWidth + dropdownPadding) / 2;
                            dropDownSecondDiv.css('left', -left_position);
                        }
                    } else {
                        if (!$(this).hasClass('qodef-menu-left-position') && !$(this).hasClass('qodef-menu-right-position')) {
                            var left_position = $(this).offset().left;

                            dropDownSecondDiv.css('left', -left_position);
                            dropDownSecondDiv.css('width', qodef.windowWidth);

                        }
                    }
                }

                if (!qodef.menuDropdownHeightSet) {
                    $(menu_items[i]).data('original_height', dropDownSecondDiv.height() + 'px');
                    dropDownSecondDiv.height(0);
                }

                if (navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {
                    $(menu_items[i]).on("touchstart mouseenter", function () {
                        dropDownSecondDiv.css({
                            'height': $(menu_items[i]).data('original_height'),
                            'overflow': 'visible',
                            'visibility': 'visible',
                            'opacity': '1'
                        });
                    }).on("mouseleave", function () {
                        dropDownSecondDiv.css({
                            'height': '0px',
                            'overflow': 'hidden',
                            'visibility': 'hidden',
                            'opacity': '0'
                        });
                    });

                } else {
                    if (qodef.body.hasClass('qodef-dropdown-animate-height')) {
                        $(menu_items[i]).mouseenter(function () {
                            dropDownSecondDiv.css({
                                'visibility': 'visible',
                                'height': '0px',
                                'opacity': '0'
                            });
                            dropDownSecondDiv.stop().animate({
                                'height': $(menu_items[i]).data('original_height'),
                                opacity: 1
                            }, 200, function () {
                                dropDownSecondDiv.css('overflow', 'visible');
                            });
                        }).mouseleave(function () {
                            dropDownSecondDiv.stop().animate({
                                'height': '0px'
                            }, 0, function () {
                                dropDownSecondDiv.css({
                                    'overflow': 'hidden',
                                    'visibility': 'hidden'
                                });
                            });
                        });
                    } else {
                        var config = {
                            interval: 0,
                            over: function () {
                                setTimeout(function () {
                                    dropDownSecondDiv.addClass('qodef-drop-down-start');
                                    dropDownSecondDiv.stop().css({'height': $(menu_items[i]).data('original_height')});
                                }, 150);
                            },
                            timeout: 150,
                            out: function () {
                                dropDownSecondDiv.stop().css({'height': '0px'});
                                dropDownSecondDiv.removeClass('qodef-drop-down-start');
                            }
                        };
                        $(menu_items[i]).hoverIntent(config);
                    }
                }
            }
        });
        $('.qodef-drop-down ul li.qodef-menu-wide ul li a').on('click', function (e) {
            if (e.which === 1) {
                var $this = $(this);
                setTimeout(function () {
                    $this.mouseleave();
                }, 500);
            }
        });

        qodef.menuDropdownHeightSet = true;
    }

    /**
     * Init Search Types
     */
    function qodefSearch() {

        var searchOpener = $('a.qodef-search-opener'),
            searchClose,
            searchForm,
            touch = false;

        if ($('html').hasClass('touch')) {
            touch = true;
        }

        if (searchOpener.length > 0) {
            //Check for type of search
            if (qodef.body.hasClass('qodef-fullscreen-search')) {

                searchClose = $('.qodef-fullscreen-search-close');

                qodefFullscreenSearch();

            }

            //Check for hover color of search
            searchOpener.each(function () {
                var thisSearchOpener = $(this);
                if (typeof thisSearchOpener.data('hover-color') !== 'undefined') {
                    var originalColor;

                    var changeSearchColor = function (event) {
                        event.data.thisSearchOpener.css('color', event.data.color);
                    };

                    if (typeof thisSearchOpener.data('color') !== 'undefined') {
                        originalColor = thisSearchOpener.data('color');
                    } else {
                        originalColor = thisSearchOpener.css('color');
                    }

                    var hoverColor = thisSearchOpener.data('hover-color');

                    thisSearchOpener.on('mouseenter', {
                        thisSearchOpener: thisSearchOpener,
                        color: hoverColor
                    }, changeSearchColor);
                    thisSearchOpener.on('mouseleave', {
                        thisSearchOpener: thisSearchOpener,
                        color: originalColor
                    }, changeSearchColor);
                }
            });

        }

        /**
         * Fullscreen search (two types: fade and from circle)
         */
        function qodefFullscreenSearch() {

            var searchHolder = $('.qodef-fullscreen-search-holder'),
                searchOverlay = $('.qodef-fullscreen-search-overlay'),
                searchField = searchHolder.find('.qodef-search-field');

            searchOpener.on('click', function (e) {
                e.preventDefault();
                var samePosition = false;
                if ($(this).data('icon-close-same-position') === 'yes') {
                    var closeTop = $(this).offset().top;
                    var closeLeft = $(this).offset().left;
                    samePosition = true;
                }
                //Fullscreen search fade
                if (searchHolder.hasClass('qodef-animate')) {
                    closeFullScreenSearch();
                } else {
                    openFullScreenSearch();
                }
                searchClose.on('click', function (e) {
                    closeFullScreenSearch();
                });
                //Close on escape
                $(document).keyup(function (e) {
                    if (e.keyCode === 27) { //KeyCode for ESC button is 27
                        closeFullScreenSearch();
                    }
                });
                //Close on click away
                $(document).mouseup(function (e) {
                    var container = $(".qodef-fullscreen-search-inner");
                    if (!container.is(e.target) && container.has(e.target).length === 0) {
                        closeFullScreenSearch();
                    }
                });

                function closeFullScreenSearch() {
                    qodef.body.removeClass('qodef-fullscreen-search-opened');
                    qodef.body.addClass('qodef-search-fade-out');
                    qodef.body.removeClass('qodef-search-fade-in');
                    searchHolder.removeClass('qodef-animate');
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefEnableScroll();
                    }
                    searchField.blur().val('');
                }

                function openFullScreenSearch() {
                    qodef.body.addClass('qodef-fullscreen-search-opened');
                    qodef.body.removeClass('qodef-search-fade-out');
                    qodef.body.addClass('qodef-search-fade-in');
                    searchHolder.addClass('qodef-animate');
                    if (samePosition) {
                        searchClose.css({
                            'top': closeTop - qodef.scroll, // Distance from top of viewport ( distance from top of window - scroll distance )
                            'left': closeLeft
                        });
                    }
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefDisableScroll();
                    }
                    setTimeout(function () {
                        searchField.focus();
                    }, 600);
                }
            });

            //Text input focus change
            $('.qodef-fullscreen-search-holder .qodef-search-field').focus(function () {
                $('.qodef-fullscreen-search-holder .qodef-field-holder .qodef-line').css("width", "100%");
            });

            $('.qodef-fullscreen-search-holder .qodef-search-field').blur(function () {
                setTimeout(function () {
                    $('.qodef-fullscreen-search-holder .qodef-field-holder .qodef-line').css("width", "0");
                }, 120);
            });

        }

    }


    /*
     **  Smooth scroll functionality for Vertical Menu
     */
    function qodefVerticalMenuScroll() {

        function verticalSideareascroll(event) {
            var delta = 0;
            if (!event) event = window.event;
            if (event.wheelDelta) {
                delta = event.wheelDelta / 120;
            } else if (event.detail) {
                delta = -event.detail / 3;
            }
            if (delta)
                handle(delta);
            if (event.preventDefault)
                event.preventDefault();
            event.returnValue = false;
        }

        function handle(delta) {
            if (delta < 0) {
                if (Math.abs(margin) <= maxMargin) {
                    margin += delta * 20;
                    $(verticalMenuInner).css('margin-top', margin);
                }
            } else {
                if (margin <= -20) {
                    margin += delta * 20;
                    $(verticalMenuInner).css('margin-top', margin);
                }
            }
        }

        if ($('.qodef-vertical-menu-area').length && qodef.windowWidth < 1500) {

            var browserHeight = qodef.windowHeight;
            var verticalMenuArea = $('.qodef-vertical-menu-area');
            var verticalMenuInner = $('.qodef-vertical-menu-area .qodef-vertical-menu-area-inner');
            var verticalMenu = verticalMenuInner.find('.qodef-vertical-menu');
            var verticalMenuHeight = verticalMenu.outerHeight() + parseInt(verticalMenuArea.css('padding-top')) + parseInt(verticalMenuArea.css('padding-bottom'));
            var margin = 0;
            var maxMargin = (browserHeight - verticalMenuHeight) / 2;

            $(verticalMenuArea).on('mouseenter',
                function () {
                    qodef.modules.common.qodefDisableScroll();
                    if (window.addEventListener) {
                        window.addEventListener('mousewheel', verticalSideareascroll, false);
                        window.addEventListener('DOMMouseScroll', verticalSideareascroll, false);
                    }
                    window.onmousewheel = document.onmousewheel = verticalSideareascroll;
                });
            $(verticalMenuArea).on('mouseleave',
                function () {
                    qodef.modules.common.qodefEnableScroll();
                    window.removeEventListener('mousewheel', verticalSideareascroll, false);
                    window.removeEventListener('DOMMouseScroll', verticalSideareascroll, false);
                }
            );
        }
    }

    /**
     * Function object that represents vertical menu area.
     * @returns {{init: Function}}
     */
    var qodefVerticalMenu = function () {
        /**
         * Main vertical area object that used through out function
         * @type {jQuery object}
         */
        var verticalMenuObject = $('.qodef-vertical-menu-area');


        var initNavigation = function () {
            var varticalMenuOpener = verticalMenuObject.find('.qodef-vertical-menu-opener a'),
                verticalMenuNavHolder = verticalMenuObject.find('.qodef-vertical-menu-nav-holder-outer'),
                menuItemWithChild = verticalMenuObject.find('.qodef-fullscreen-menu > ul li.qodef-has-sub > a'),
                menuItemWithoutChild = verticalMenuObject.find('.qodef-fullscreen-menu ul li:not(.qodef-has-sub) a');

            //set height of vertical menu holder and initialize nicescroll
            verticalMenuNavHolder.height(qodef.windowHeight).niceScroll({
                scrollspeed: 30,
                mousescrollstep: 20,
                cursorwidth: 0,
                cursorborder: 0,
                cursorborderradius: 0,
                cursorcolor: "transparent",
                autohidemode: false,
                horizrailenabled: false
            }); //200 is top and bottom padding of holder

            //set height of vertical menu holder on resize
            $(window).resize(function () {
                verticalMenuNavHolder.height(qodef.windowHeight);
            });

            varticalMenuOpener.on('click', function (e) {
                e.preventDefault();

                if (!verticalMenuNavHolder.hasClass('active')) {
                    verticalMenuNavHolder.addClass('active');
                    verticalMenuObject.addClass('opened');
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefDisableScroll();
                    }
                } else {
                    verticalMenuNavHolder.removeClass('active');
                    verticalMenuObject.removeClass('opened');
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefEnableScroll();
                    }
                }
            });

            $('.qodef-content').on('click', function () {
                if (verticalMenuNavHolder.hasClass('active')) {
                    verticalMenuNavHolder.removeClass('active');
                    verticalMenuObject.removeClass('opened');
                    if (!qodef.body.hasClass('page-template-full_screen-php')) {
                        qodef.modules.common.qodefEnableScroll();
                    }
                }
            });

            //logic for open sub menus in popup menu
            menuItemWithChild.on('tap click', function (e) {
                e.preventDefault();

                if ($(this).parent().hasClass('qodef-has-sub')) {
                    var submenu = $(this).parent().find('> ul.sub_menu');
                    if (submenu.is(':visible')) {
                        submenu.slideUp(200, function () {
                            verticalMenuNavHolder.getNiceScroll().resize();
                        });
                        $(this).parent().removeClass('open_sub');
                    } else {
                        if ($(this).parent().siblings().hasClass('open_sub')) {
                            $(this).parent().siblings().each(function () {
                                var sibling = $(this);
                                if (sibling.hasClass('open_sub')) {
                                    var openedUl = sibling.find('> ul.sub_menu');
                                    openedUl.slideUp(200, function () {
                                        verticalMenuNavHolder.getNiceScroll().resize();
                                    });
                                    sibling.removeClass('open_sub');
                                }
                                if (sibling.find('.open_sub')) {
                                    var openedUlUl = sibling.find('.open_sub').find('> ul.sub_menu');
                                    openedUlUl.slideUp(200, function () {
                                        verticalMenuNavHolder.getNiceScroll().resize();
                                    });
                                    sibling.find('.open_sub').removeClass('open_sub');
                                }
                            });
                        }

                        $(this).parent().addClass('open_sub');
                        submenu.slideDown(200, function () {
                            verticalMenuNavHolder.getNiceScroll().resize();
                        });
                    }
                }
                return false;
            });

        };

        return {
            /**
             * Calls all necessary functionality for vertical menu area if vertical area object is valid
             */
            init: function () {
                if (verticalMenuObject.length) {
                    initNavigation();

                }
            }
        };
    };


    function qodefMenuLine() {
        var firstLevelMenus = $('.qodef-main-menu > ul');

        if (firstLevelMenus.length) {
            firstLevelMenus.each(function () {
                var mainMenu = $(this);

                mainMenu.append('<li class="qodef-main-menu-line"></li>');

                var menuLine = mainMenu.find('.qodef-main-menu-line'),
                    menuItems = mainMenu.find('> li.menu-item'),
                    initialOffset;

                menuLine.css('border-color', menuItems.find('a').css('color'));

                if (menuItems.filter('.qodef-active-item').length) {
                    initialOffset = menuItems.filter('.qodef-active-item').offset().left;
                    menuLine.css('width', menuItems.filter('.qodef-active-item').outerWidth());
                } else {
                    initialOffset = menuItems.first().offset().left;
                    menuLine.css('width', menuItems.first().outerWidth());
                }

                //initial positioning
                menuLine.css('left', initialOffset - mainMenu.offset().left);

                //fx on
                menuItems.mouseenter(function () {
                    var menuItem = $(this),
                        menuItemWidth = menuItem.outerWidth(),
                        mainMenuOffset = mainMenu.offset().left,
                        menuItemOffset = menuItem.offset().left - mainMenuOffset;

                    menuLine.css('width', menuItemWidth);
                    menuLine.css('left', menuItemOffset);
                });

                //fx off
                mainMenu.mouseleave(function () {
                    if (menuItems.filter('.qodef-active-item').length) {
                        menuLine.css('width', menuItems.filter('.qodef-active-item').outerWidth());
                        initialOffset = menuItems.filter('.qodef-active-item').offset().left;
                    } else {
                        menuLine.css('width', menuItems.first().outerWidth());
                    }

                    menuLine.css('left', initialOffset - mainMenu.offset().left);
                });
            });
        }
    }

})(jQuery);