<?php
namespace TheplusAddons\WPML;
use WPML_Elementor_Module_With_Items;

if ( ! defined('ABSPATH') ) exit; // No access of directly access

class Tp_Cascading_Image extends WPML_Elementor_Module_With_Items {

	/**
	 * Get widget field name.
	 * 
	 * @return string
	 */
	public function get_items_field() {
		return 'image_cascading';
	}

	/**
	 * Get the fields inside the repeater.
	 *
	 * @return array
	 */
	public function get_fields() {
		return array(
			'text_content',
			'plus_tooltip_content_desc'
		);
	}

  	/**
     * @param string $field
	 * 
	 * Get the field title string
     *
     * @return string
     */
	protected function get_title( $field ) {
		switch($field) {
			case 'text_content':
				return esc_html__( 'Cascading Image : Text Content', 'theplus' );
			case 'plus_tooltip_content_desc':
				return esc_html__( 'Cascading Image : Description', 'theplus' );
			
			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * 
	 * Get perspective field types.
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch($field) {
			case 'text_content':
				return 'LINE';

			case 'plus_tooltip_content_desc':
				return 'AREA';

			default:
				return '';
		}
	}

}
