<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$link = get_field('page_url', get_the_ID());
?>
<div class="theplus-st6-custom-layout">
<a class="tp-quick-btn" href="<?php echo esc_url( $link ); ?>">
	<div class="theplus-st6-custom-layout-1-1"> 
		<div class="theplus-st6-custom-layout-1-1-in">
			<?php
				if( get_field('image', get_the_ID()) ){
					?> <img src="<?php the_field('image'); ?>" /> <?php
				}
				
				$freepro = get_field_object( 'freepro' );
				$freepro_value = !empty($freepro['value']) ? $freepro['value'] : '';
				if(!empty($freepro_value)){ 
					if($freepro_value==='Free'){
						?>
						<span class="tp-free-pin"><svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="12" height="12" rx="6" fill="#14C38E"/><path d="M3.82422 6.28378L5.04044 7.5L8.04044 4.5" stroke="white" stroke-linecap="round" stroke-linejoin="round"/></svg>FREE</span>
						<?php 
					}else if($freepro_value==='Pro'){
						?>
						<span class="tp-pro-pin"><svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
<rect width="12" height="12" fill="url(#pattern0)"/>
<defs>
<pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
<use xlink:href="#image0_468_4950" transform="scale(0.00195312)"/>
</pattern>
<image id="image0_468_4950" width="512" height="512" xlink:href="data:image/png;base64,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"/>
</defs>
</svg>PRO</span>
						<?php
					}else if($freepro_value==='Freemium'){
						?>
						<span  class="tp-freemium-pin"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
<path d="M6.67185 4.48495H9.28835C9.37044 4.48495 9.45253 4.50547 9.51922 4.55164C9.63209 4.6286 9.7347 4.79277 9.58592 5.12625C9.35505 5.64955 7.10794 10.7646 6.69237 11.7085C6.63081 11.8522 6.50255 11.9599 6.34864 11.9907C6.23064 12.0112 6.09725 11.9856 6.0049 11.8163C5.96386 11.7393 5.94334 11.647 5.94334 11.5598V7.4811L3.50127 7.47084C3.13188 7.47084 2.89075 7.08606 3.04979 6.75258C3.05492 6.74745 3.05492 6.74232 3.06005 6.73719C3.30118 6.23954 5.56882 1.12454 5.92281 0.319064C5.96899 0.216456 6.04081 0.124109 6.13829 0.0625444C6.24603 -0.00415074 6.38455 -0.0400635 6.52307 0.0728052C6.61542 0.149761 6.66159 0.26263 6.66159 0.380629L6.67185 4.48495Z" fill="#FFB297"/>
</svg>
FREEMIUM</span>
						<?php
					}
				}
			?>
		</div>
	</div>	
	<div class="theplus-st6-custom-layout-1-2">
			<span class="tpgb-filter-title"><?php echo get_the_title(); ?></span>			
	</div>
</a>
</div>